/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.upload;

import android.text.TextUtils;
import com.sobot.network.http.model.UploadFileResult;
import com.sobot.network.http.upload.SobotUploadModel;
import com.sobot.network.http.upload.SobotUploadModelBase;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SobotCommonGsonUtil {
    public static SobotUploadModel jsonToCommonModel(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        SobotUploadModel bean = new SobotUploadModel();
        try {
            JSONObject jsonObject = new JSONObject(json);
            if (jsonObject.has("code")) {
                bean.setCode(SobotCommonGsonUtil.filterNull(jsonObject.optString("code")));
            }
            if ("1".equals(SobotCommonGsonUtil.filterNull(jsonObject.optString("code")))) {
                SobotUploadModelBase base = new SobotUploadModelBase();
                JSONObject data = jsonObject.getJSONObject("data");
                if (data.has("status")) {
                    base.setStatus(SobotCommonGsonUtil.filterNull(data.optString("status")));
                }
                if (data.has("switchFlag")) {
                    base.setSwitchFlag(SobotCommonGsonUtil.filterNull(data.optString("switchFlag")));
                }
                if (data.has("msg")) {
                    base.setMsg(SobotCommonGsonUtil.filterNull(data.optString("msg")));
                }
                bean.setData(base);
            }
            if (jsonObject.has("msg")) {
                bean.setMsg(SobotCommonGsonUtil.filterNull(jsonObject.optString("msg")));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return bean;
    }

    public static UploadFileResult obtainUploadFileResult(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(json);
            UploadFileResult data = new UploadFileResult();
            data.setMsgId(jsonObject.optString("msgId"));
            data.setUrl(jsonObject.optString("msg"));
            return data;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String filterNull(String str) {
        if (!TextUtils.isEmpty((CharSequence)str)) {
            if (str.equals("null")) {
                return null;
            }
            String msgHint = str.replace("\n", "<br/>");
            if (msgHint.startsWith("<br/>")) {
                msgHint = msgHint.substring(5, msgHint.length());
            }
            if (msgHint.endsWith("<br/>")) {
                msgHint = msgHint.substring(0, msgHint.length() - 5);
            }
            return msgHint;
        }
        return null;
    }

    private static String filterNullStr(String str) {
        if (!str.equalsIgnoreCase("null")) {
            return str;
        }
        return null;
    }

    public static String map2Json(Map<String, String> map) {
        if (map != null && map.size() > 0) {
            JSONObject a = new JSONObject(map);
            return a.toString();
        }
        return "";
    }

    public static String map2Str(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if ("items".equals(entry.getKey()) || "level".equals(entry.getKey())) {
                    sb.append("\"" + entry.getKey() + "\":" + entry.getValue() + ",");
                    continue;
                }
                sb.append("\"" + entry.getKey() + "\":\"" + entry.getValue() + "\",");
            }
            String tmpstr = sb.toString();
            return tmpstr.substring(0, tmpstr.lastIndexOf(",")) + "}";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static <T> JSONArray praseList2Json(List<T> list) {
        JSONArray json = new JSONArray();
        try {
            for (T data : list) {
                Field[] field;
                JSONObject jo = new JSONObject();
                for (Field f : field = data.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    Method m = SobotCommonGsonUtil.convertGetter(data.getClass(), f.getName(), new Class[0]);
                    if (m == null) continue;
                    String result = (String)m.invoke(data, new Object[0]);
                    jo.put(f.getName(), (Object)result);
                }
                json.put((Object)jo);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public static Method convertGetter(Class cla, String field, Class<?> ... parameterTypes) {
        String str1 = field.substring(0, 1);
        String str2 = field.substring(1);
        String method_set = "get" + str1.toUpperCase() + str2;
        Method method1 = null;
        try {
            method1 = cla.getMethod(method_set, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method1;
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str) || "null".equals(str);
    }
}

