/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.upload;

import android.util.Log;
import com.sobot.network.http.model.SobotProgress;
import com.sobot.network.http.request.RequestCall;
import com.sobot.network.http.task.XExecutor;
import com.sobot.network.http.upload.SobotUploadTask;
import com.sobot.network.http.upload.SobotUploadThreadPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SobotUpload {
    private static SobotUpload instance;
    private Map<String, SobotUploadTask<?>> taskMap;
    private SobotUploadThreadPool threadPool = new SobotUploadThreadPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SobotUpload getInstance() {
        if (instance != null) return instance;
        Class<SobotUpload> clazz = SobotUpload.class;
        synchronized (SobotUpload.class) {
            if (instance != null) return instance;
            instance = new SobotUpload();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SobotUpload() {
        this.taskMap = new LinkedHashMap();
    }

    public static <T> SobotUploadTask<T> request(String tag, RequestCall request) {
        Map<String, SobotUploadTask<?>> taskMap = SobotUpload.getInstance().getTaskMap();
        SobotUploadTask<Object> task = taskMap.get(tag);
        if (task == null) {
            task = new SobotUploadTask(tag, request);
            taskMap.put(tag, task);
        }
        return task;
    }

    public static <T> SobotUploadTask<T> restore(SobotProgress progress) {
        Map<String, SobotUploadTask<?>> taskMap = SobotUpload.getInstance().getTaskMap();
        SobotUploadTask<Object> task = taskMap.get(progress.tag);
        if (task == null) {
            task = new SobotUploadTask(progress);
            taskMap.put(progress.tag, task);
        }
        return task;
    }

    public static List<SobotUploadTask<?>> restore(List<SobotProgress> progressList) {
        Map<String, SobotUploadTask<?>> taskMap = SobotUpload.getInstance().getTaskMap();
        ArrayList tasks = new ArrayList();
        for (SobotProgress progress : progressList) {
            SobotUploadTask<Object> task = taskMap.get(progress.tag);
            if (task == null) {
                task = new SobotUploadTask(progress);
                taskMap.put(progress.tag, task);
            }
            tasks.add(task);
        }
        return tasks;
    }

    public void startAll() {
        for (Map.Entry<String, SobotUploadTask<?>> entry : this.taskMap.entrySet()) {
            SobotUploadTask<?> task = entry.getValue();
            if (task == null) {
                Log.w((String)"", (String)("can't find task with tag = " + entry.getKey()));
                continue;
            }
            task.start();
        }
    }

    public void pauseAll() {
        SobotUploadTask<?> task;
        for (Map.Entry<String, SobotUploadTask<?>> entry : this.taskMap.entrySet()) {
            task = entry.getValue();
            if (task == null) {
                Log.w((String)"", (String)("can't find task with tag = " + entry.getKey()));
                continue;
            }
            if (task.progress.status == 2) continue;
            task.pause();
        }
        for (Map.Entry<String, SobotUploadTask<?>> entry : this.taskMap.entrySet()) {
            task = entry.getValue();
            if (task == null) {
                Log.w((String)"", (String)("can't find task with tag = " + entry.getKey()));
                continue;
            }
            if (task.progress.status != 2) continue;
            task.pause();
        }
    }

    public void removeAll() {
        SobotUploadTask task;
        HashMap map = new HashMap(this.taskMap);
        for (Map.Entry entry : map.entrySet()) {
            task = (SobotUploadTask)entry.getValue();
            if (task == null) {
                Log.w((String)"", (String)("can't find task with tag = " + (String)entry.getKey()));
                continue;
            }
            if (task.progress.status == 2) continue;
            task.remove();
        }
        for (Map.Entry entry : map.entrySet()) {
            task = (SobotUploadTask)entry.getValue();
            if (task == null) {
                Log.w((String)"", (String)("can't find task with tag = " + (String)entry.getKey()));
                continue;
            }
            if (task.progress.status != 2) continue;
            task.remove();
        }
    }

    public SobotUploadThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Map<String, SobotUploadTask<?>> getTaskMap() {
        return this.taskMap;
    }

    public SobotUploadTask<?> getTask(String tag) {
        return this.taskMap.get(tag);
    }

    public boolean hasTask(String tag) {
        return this.taskMap.containsKey(tag);
    }

    public SobotUploadTask<?> removeTask(String tag) {
        return this.taskMap.remove(tag);
    }

    public void addOnAllTaskEndListener(XExecutor.OnAllTaskEndListener listener) {
        this.threadPool.getExecutor().addOnAllTaskEndListener(listener);
    }

    public void removeOnAllTaskEndListener(XExecutor.OnAllTaskEndListener listener) {
        this.threadPool.getExecutor().removeOnAllTaskEndListener(listener);
    }

    public void unRegister() {
        for (SobotUploadTask<?> task : this.taskMap.values()) {
            task.listeners.clear();
        }
    }
}

