/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.upload;

import android.text.TextUtils;
import android.util.Log;
import com.sobot.network.http.SobotOkHttpUtils;
import com.sobot.network.http.db.SobotDownloadManager;
import com.sobot.network.http.log.SobotNetLogUtils;
import com.sobot.network.http.model.SobotProgress;
import com.sobot.network.http.model.UploadFileResult;
import com.sobot.network.http.request.ProgressRequestBody;
import com.sobot.network.http.request.RequestCall;
import com.sobot.network.http.task.PriorityRunnable;
import com.sobot.network.http.upload.SobotCommonGsonUtil;
import com.sobot.network.http.upload.SobotUpload;
import com.sobot.network.http.upload.SobotUploadListener;
import com.sobot.network.http.upload.SobotUploadModel;
import com.sobot.network.http.upload.SobotUploadModelBase;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import okhttp3.Call;
import okhttp3.Response;

public class SobotUploadTask<T>
implements Runnable {
    private static final String TAG = "SobotUploadTask";
    public SobotProgress progress;
    public Map<Object, SobotUploadListener> listeners;
    private ThreadPoolExecutor executor;
    private PriorityRunnable priorityRunnable;

    public SobotUploadTask(String tag, RequestCall request) {
        this.progress = new SobotProgress();
        this.progress.tag = tag;
        this.progress.isUpload = true;
        this.progress.status = 0;
        this.progress.totalSize = -1L;
        this.progress.request = request;
        this.executor = SobotUpload.getInstance().getThreadPool().getExecutor();
        this.listeners = new HashMap<Object, SobotUploadListener>();
    }

    public SobotUploadTask(SobotProgress progress) {
        this.progress = progress;
        this.executor = SobotUpload.getInstance().getThreadPool().getExecutor();
        this.listeners = new HashMap<Object, SobotUploadListener>();
    }

    public SobotUploadTask<T> priority(int priority) {
        this.progress.priority = priority;
        return this;
    }

    public SobotUploadTask<T> filePath(String filePath) {
        if (filePath != null && !TextUtils.isEmpty((CharSequence)filePath.trim())) {
            this.progress.filePath = filePath;
        }
        return this;
    }

    public SobotUploadTask<T> tmpTag(String tmpTag) {
        if (tmpTag != null && !TextUtils.isEmpty((CharSequence)tmpTag.trim())) {
            this.progress.tmpTag = tmpTag;
        }
        return this;
    }

    public SobotUploadTask<T> register(SobotUploadListener listener) {
        if (listener != null) {
            this.listeners.put(listener.tag, listener);
        }
        return this;
    }

    public void unRegister(SobotUploadListener listener) {
        this.listeners.remove(listener.tag);
    }

    public void unRegister(String tag) {
        this.listeners.remove(tag);
    }

    public SobotUploadTask<T> start() {
        if (SobotUpload.getInstance().getTask(this.progress.tag) == null) {
            Log.i((String)TAG, (String)"you must call SobotUploadTask#save() before SobotUploadTask#start()\uff01");
        }
        if (this.progress.status != 1 && this.progress.status != 2) {
            this.postOnStart(this.progress);
            this.postWaiting(this.progress);
            this.priorityRunnable = new PriorityRunnable(this.progress.priority, this);
            this.executor.execute(this.priorityRunnable);
        } else {
            Log.w((String)TAG, (String)("the task with tag " + this.progress.tag + " is already in the upload queue, current task status is " + this.progress.status));
        }
        return this;
    }

    public void restart() {
        this.pause();
        this.progress.status = 0;
        this.progress.currentSize = 0L;
        this.progress.fraction = 0.0f;
        this.progress.speed = 0L;
        this.start();
    }

    public void pause() {
        this.executor.remove(this.priorityRunnable);
        if (this.progress.status == 1) {
            this.postPause(this.progress);
        } else if (this.progress.status == 2) {
            this.progress.speed = 0L;
            this.progress.status = 3;
        } else {
            Log.w((String)TAG, (String)("only the task with status WAITING(1) or LOADING(2) can pause, current status is " + this.progress.status));
        }
    }

    public SobotUploadTask<T> remove() {
        this.pause();
        SobotUploadTask<?> task = SobotUpload.getInstance().removeTask(this.progress.tag);
        this.postOnRemove(this.progress);
        return task;
    }

    @Override
    public void run() {
        block12: {
            Response response;
            this.progress.status = 2;
            this.postLoading(this.progress);
            try {
                final RequestCall requestCall = this.progress.request;
                requestCall.getOkHttpRequest().uploadInterceptor(new ProgressRequestBody.UploadInterceptor(){

                    @Override
                    public void uploadProgress(SobotProgress innerProgress) {
                        Call call = requestCall.getCall();
                        if (call.isCanceled()) {
                            return;
                        }
                        if (SobotUploadTask.this.progress.status != 2) {
                            call.cancel();
                            return;
                        }
                        SobotUploadTask.this.progress.from(innerProgress);
                        SobotUploadTask.this.postLoading(SobotUploadTask.this.progress);
                    }
                });
                Call rawCall = requestCall.buildCall(null);
                response = rawCall.execute();
            }
            catch (Exception e) {
                this.postOnError(this.progress, e);
                return;
            }
            if (response.isSuccessful()) {
                String resultStr = null;
                try {
                    resultStr = response.body().string();
                    SobotNetLogUtils.i("uploadFile----->:" + resultStr);
                    SobotUploadModel result = SobotCommonGsonUtil.jsonToCommonModel(resultStr);
                    if (result != null) {
                        if ("1".equals(result.getCode())) {
                            if (result.getData() != null) {
                                SobotUploadModelBase data = (SobotUploadModelBase)result.getData();
                                UploadFileResult tmpData = SobotCommonGsonUtil.obtainUploadFileResult(data.getMsg());
                                if (tmpData != null && !TextUtils.isEmpty((CharSequence)tmpData.getMsgId())) {
                                    this.progress.tag = tmpData.getMsgId();
                                    this.progress.url = tmpData.getUrl();
                                    this.postOnFinish(this.progress, data);
                                } else {
                                    this.postOnError(this.progress, new RuntimeException(result.getMsg()));
                                }
                            }
                        } else {
                            this.postOnError(this.progress, new RuntimeException(result.getMsg()));
                        }
                        break block12;
                    }
                    this.postOnError(this.progress, new RuntimeException("\u7f51\u7edc\u9519\u8bef"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.postOnError(this.progress, new RuntimeException("\u7f51\u7edc\u9519\u8bef"));
                }
            } else {
                this.postOnError(this.progress, new RuntimeException(response.message()));
            }
        }
    }

    private void postOnStart(final SobotProgress progress) {
        progress.speed = 0L;
        progress.status = 0;
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotUploadListener listener : SobotUploadTask.this.listeners.values()) {
                    listener.onStart(progress);
                }
            }
        });
    }

    private void postWaiting(final SobotProgress progress) {
        progress.speed = 0L;
        progress.status = 1;
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotUploadListener listener : SobotUploadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postPause(final SobotProgress progress) {
        progress.speed = 0L;
        progress.status = 3;
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotUploadListener listener : SobotUploadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postLoading(final SobotProgress progress) {
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotUploadListener listener : SobotUploadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postOnError(final SobotProgress progress, Throwable throwable) {
        progress.speed = 0L;
        progress.status = 4;
        progress.exception = throwable;
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotUploadListener listener : SobotUploadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                    listener.onError(progress);
                }
            }
        });
    }

    private void postOnFinish(final SobotProgress progress, final SobotUploadModelBase result) {
        progress.speed = 0L;
        progress.fraction = 1.0f;
        progress.status = 5;
        this.updateDatabase(progress);
        SobotDownloadManager.getInstance().replace(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotUploadListener listener : SobotUploadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                    listener.onFinish(result, progress);
                }
                if (!TextUtils.isEmpty((CharSequence)progress.tmpTag)) {
                    SobotUpload.getInstance().removeTask(progress.tmpTag);
                } else {
                    SobotUpload.getInstance().removeTask(progress.tag);
                }
            }
        });
    }

    private void postOnRemove(final SobotProgress progress) {
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotUploadListener listener : SobotUploadTask.this.listeners.values()) {
                    listener.onRemove(progress);
                }
                SobotUploadTask.this.listeners.clear();
            }
        });
    }

    private void updateDatabase(SobotProgress progress) {
    }
}

