package com.sobot.pictureframe;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.view.WindowManager;
import android.widget.ImageView;

import com.sobot.chat.imageloader.SobotGlideV4ImageLoader;
import com.sobot.chat.imageloader.SobotImageLoader;

//图片显示工具类
public class SobotBitmapUtil {

    private static SobotImageLoader sImageLoader;

    private static final SobotImageLoader getImageLoader() {
        if (sImageLoader == null) {
            synchronized (SobotBitmapUtil.class) {
                if (sImageLoader == null) {
                    if (isClassExists("com.bumptech.glide.request.RequestOptions")) {
                        sImageLoader = new SobotGlideV4ImageLoader();
                    } else if (isClassExists("com.bumptech.glide.Glide")) {
                        sImageLoader = new SobotGlideImageLoader();
                    } else if (isClassExists("com.squareup.picasso.Picasso")) {
                        sImageLoader = new SobotPicassoImageLoader();
                    } else if (isClassExists("com.nostra13.universalimageloader.core.ImageLoader")) {
                        sImageLoader = new SobotUILImageLoader();
                    } else if (isClassExists("com.facebook.drawee.backends.pipeline.Fresco")) {
                        sImageLoader = new SobotFrescoImageLoader();
                    } else {
                        throw new RuntimeException("必须在(Glide、Picasso、universal-image-loader、Fresco)中选择一个图片加载库添加依赖,或者检查是否添加了相应的混淆配置");
                    }
                }
            }
        }
        return sImageLoader;
    }

    private static final boolean isClassExists(String classFullName) {
        try {
            Class.forName(classFullName);
            return true;
        } catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void setImageLoader(SobotImageLoader imageLoader) {
        sImageLoader = imageLoader;
    }

    public static void display(Context context, String url,
                               ImageView imageView, int defaultPic, int error) {

        if (context != null && imageView != null) {
            getImageLoader().displayImage(context, imageView, url, defaultPic, error, imageView.getWidth(), imageView.getHeight(), null);
        }
    }

    public static void display(Context context, String url,
                               ImageView imageView) {

        if (context != null && imageView != null) {
            getImageLoader().displayImage(context, imageView, url, 0, 0, imageView.getWidth(), imageView.getHeight(), null);
        }
    }


    public static void display(Context context, int resourceId, ImageView imageView) {
        if (context != null && imageView != null) {
            getImageLoader().displayImage(context, imageView, resourceId, 0, 0, imageView.getWidth(), imageView.getHeight(), null);
        }
    }

    @SuppressWarnings("deprecation")
    public static Bitmap compress(String filePath, Context context, boolean isCamera) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.Q || isCamera) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;// 设置后decode图片不会返回一个bitmap对象，但是会将图片的信息封装到Options中
            BitmapFactory.decodeFile(filePath, options);
            WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);

            int width = wm.getDefaultDisplay().getWidth();
            int height = wm.getDefaultDisplay().getHeight();
            options.inSampleSize = SobotPictureUtils.calculateInSampleSize(options, width, height);
            options.inJustDecodeBounds = false;

            return BitmapFactory.decodeFile(filePath, options);
        } else {

            return SobotPictureUtils.getBitmapFromUri(context, SobotPictureUtils.getImageContentUri(context, filePath));

        }
    }
}