/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.pictureframe;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.view.WindowManager;
import android.widget.ImageView;
import com.sobot.chat.imageloader.SobotGlideV4ImageLoader;
import com.sobot.chat.imageloader.SobotImageLoader;
import com.sobot.pictureframe.SobotFrescoImageLoader;
import com.sobot.pictureframe.SobotGlideImageLoader;
import com.sobot.pictureframe.SobotPicassoImageLoader;
import com.sobot.pictureframe.SobotPictureUtils;
import com.sobot.pictureframe.SobotUILImageLoader;

public class SobotBitmapUtil {
    private static SobotImageLoader sImageLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final SobotImageLoader getImageLoader() {
        if (sImageLoader != null) return sImageLoader;
        Class<SobotBitmapUtil> clazz = SobotBitmapUtil.class;
        synchronized (SobotBitmapUtil.class) {
            if (sImageLoader != null) return sImageLoader;
            if (SobotBitmapUtil.isClassExists("com.bumptech.glide.request.RequestOptions")) {
                sImageLoader = new SobotGlideV4ImageLoader();
            } else if (SobotBitmapUtil.isClassExists("com.bumptech.glide.Glide")) {
                sImageLoader = new SobotGlideImageLoader();
            } else if (SobotBitmapUtil.isClassExists("com.squareup.picasso.Picasso")) {
                sImageLoader = new SobotPicassoImageLoader();
            } else if (SobotBitmapUtil.isClassExists("com.nostra13.universalimageloader.core.ImageLoader")) {
                sImageLoader = new SobotUILImageLoader();
            } else {
                if (!SobotBitmapUtil.isClassExists("com.facebook.drawee.backends.pipeline.Fresco")) throw new RuntimeException("\u5fc5\u987b\u5728(Glide\u3001Picasso\u3001universal-image-loader\u3001Fresco)\u4e2d\u9009\u62e9\u4e00\u4e2a\u56fe\u7247\u52a0\u8f7d\u5e93\u6dfb\u52a0\u4f9d\u8d56,\u6216\u8005\u68c0\u67e5\u662f\u5426\u6dfb\u52a0\u4e86\u76f8\u5e94\u7684\u6df7\u6dc6\u914d\u7f6e");
                sImageLoader = new SobotFrescoImageLoader();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sImageLoader;
        }
    }

    private static final boolean isClassExists(String classFullName) {
        try {
            Class.forName(classFullName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void setImageLoader(SobotImageLoader imageLoader) {
        sImageLoader = imageLoader;
    }

    public static void display(Context context, String url, ImageView imageView, int defaultPic, int error) {
        if (context != null && imageView != null) {
            SobotBitmapUtil.getImageLoader().displayImage(context, imageView, url, defaultPic, error, imageView.getWidth(), imageView.getHeight(), null);
        }
    }

    public static void display(Context context, String url, ImageView imageView) {
        if (context != null && imageView != null) {
            SobotBitmapUtil.getImageLoader().displayImage(context, imageView, url, 0, 0, imageView.getWidth(), imageView.getHeight(), null);
        }
    }

    public static void display(Context context, int resourceId, ImageView imageView) {
        if (context != null && imageView != null) {
            SobotBitmapUtil.getImageLoader().displayImage(context, imageView, resourceId, 0, 0, imageView.getWidth(), imageView.getHeight(), null);
        }
    }

    public static Bitmap compress(String filePath, Context context, boolean isCamera) {
        if (Build.VERSION.SDK_INT < 29 || isCamera) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            WindowManager wm = (WindowManager)context.getSystemService("window");
            int width = wm.getDefaultDisplay().getWidth();
            int height = wm.getDefaultDisplay().getHeight();
            options.inSampleSize = SobotPictureUtils.calculateInSampleSize(options, width, height);
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        return SobotPictureUtils.getBitmapFromUri(context, SobotPictureUtils.getImageContentUri(context, filePath));
    }
}

