/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.pictureframe;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.datasource.BaseBitmapDataSubscriber;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.sobot.chat.imageloader.SobotImageLoader;
import java.io.File;
import java.util.concurrent.Executor;

public class SobotFrescoImageLoader
extends SobotImageLoader {
    public void displayImage(Context context, final ImageView imageView, String path, @DrawableRes int loadingResId, @DrawableRes int failResId, int width, int height, SobotImageLoader.SobotDisplayImageListener listener) {
        File file;
        if (TextUtils.isEmpty((CharSequence)path) || "null".equals(path)) {
            return;
        }
        if (imageView == null) {
            return;
        }
        ImageRequestBuilder builder = path.startsWith("http") ? ImageRequestBuilder.newBuilderWithSource((Uri)Uri.parse((String)path)) : ((file = new File(path)) != null ? ImageRequestBuilder.newBuilderWithSource((Uri)Uri.fromFile((File)file)) : ImageRequestBuilder.newBuilderWithSource((Uri)Uri.parse((String)path)));
        if (width > 0 && height > 0) {
            builder.setResizeOptions(new ResizeOptions(width, height));
        }
        ImageRequest imageRequest = builder.build();
        ImagePipeline imagePipeline = Fresco.getImagePipeline();
        DataSource dataSource = imagePipeline.fetchDecodedImage(imageRequest, (Object)context);
        BaseBitmapDataSubscriber subscriber = new BaseBitmapDataSubscriber(){

            public void onNewResultImpl(@Nullable Bitmap bitmap) {
                new AsyncTask<Bitmap, Void, Bitmap>(){

                    protected Bitmap doInBackground(Bitmap ... params) {
                        Bitmap bitmap = params[0];
                        Bitmap result = null;
                        if (bitmap != null && !bitmap.isRecycled()) {
                            result = bitmap.copy(Bitmap.Config.RGB_565, false);
                        }
                        return result;
                    }

                    protected void onPostExecute(Bitmap bitmap) {
                        if (bitmap != null) {
                            imageView.setImageBitmap(bitmap);
                        }
                    }
                }.execute((Object[])new Bitmap[]{bitmap});
            }

            public void onFailureImpl(DataSource dataSource) {
            }
        };
        dataSource.subscribe((DataSubscriber)subscriber, (Executor)UiThreadImmediateExecutorService.getInstance());
    }

    public void displayImage(Context context, ImageView imageView, @DrawableRes int targetResId, @DrawableRes int loadingResId, @DrawableRes int failResId, int width, int height, SobotImageLoader.SobotDisplayImageListener listener) {
        try {
            if (imageView != null) {
                imageView.setBackgroundResource(targetResId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

