/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.pictureframe;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import com.bumptech.glide.BitmapRequestBuilder;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.sobot.chat.imageloader.SobotImageLoader;

public class SobotGlideImageLoader
extends SobotImageLoader {
    public void displayImage(Context context, final ImageView imageView, final String path, @DrawableRes int loadingResId, @DrawableRes int failResId, int width, int height, final SobotImageLoader.SobotDisplayImageListener listener) {
        if (TextUtils.isEmpty((CharSequence)path) || "null".equals(path)) {
            return;
        }
        if (imageView == null) {
            return;
        }
        BitmapRequestBuilder builder = Glide.with((Context)context).load(path).asBitmap().placeholder(loadingResId).error(failResId);
        if (width != 0 || height != 0) {
            builder.override(width, height);
        }
        builder.listener((RequestListener)new RequestListener<String, Bitmap>(){

            public boolean onException(Exception e, String model, Target<Bitmap> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Bitmap resource, String model, Target<Bitmap> target, boolean isFromMemoryCache, boolean isFirstResource) {
                if (listener != null) {
                    listener.onSuccess((View)imageView, path);
                }
                return false;
            }
        }).into(imageView);
    }

    public void displayImage(Context context, final ImageView imageView, @DrawableRes int targetResId, @DrawableRes int loadingResId, @DrawableRes int failResId, int width, int height, final SobotImageLoader.SobotDisplayImageListener listener) {
        BitmapRequestBuilder builder = Glide.with((Context)context).load(Integer.valueOf(targetResId)).asBitmap().placeholder(loadingResId).error(failResId);
        if (width != 0 || height != 0) {
            builder.override(width, height);
        }
        builder.listener((RequestListener)new RequestListener<Integer, Bitmap>(){

            public boolean onException(Exception e, Integer model, Target<Bitmap> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Bitmap resource, Integer model, Target<Bitmap> target, boolean isFromMemoryCache, boolean isFirstResource) {
                if (listener != null) {
                    listener.onSuccess((View)imageView, "");
                }
                return false;
            }
        }).into(imageView);
    }
}

