/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.pictureframe;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import com.nostra13.universalimageloader.core.imageaware.ImageViewAware;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;
import com.sobot.chat.imageloader.SobotImageLoader;

public class SobotUILImageLoader
extends SobotImageLoader {
    private void initImageLoader(Context context) {
        if (!ImageLoader.getInstance().isInited()) {
            DisplayImageOptions options = new DisplayImageOptions.Builder().cacheInMemory(true).cacheOnDisk(true).build();
            ImageLoaderConfiguration config = new ImageLoaderConfiguration.Builder(context.getApplicationContext()).threadPoolSize(3).defaultDisplayImageOptions(options).build();
            ImageLoader.getInstance().init(config);
        }
    }

    public void displayImage(Context context, ImageView imageView, String path, @DrawableRes int loadingResId, @DrawableRes int failResId, int width, int height, final SobotImageLoader.SobotDisplayImageListener listener) {
        this.initImageLoader(context);
        DisplayImageOptions options = new DisplayImageOptions.Builder().showImageOnLoading(loadingResId).showImageOnFail(failResId).showImageForEmptyUri(failResId).cacheInMemory(true).cacheOnDisk(true).bitmapConfig(Bitmap.Config.RGB_565).build();
        ImageSize imageSize = width != 0 || height != 0 ? new ImageSize(width, height) : null;
        ImageLoader.getInstance().displayImage(path, (ImageAware)new ImageViewAware(imageView), options, imageSize, (ImageLoadingListener)new SimpleImageLoadingListener(){

            public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                if (listener != null) {
                    listener.onSuccess(view, imageUri);
                }
            }
        }, null);
    }

    public void displayImage(Context context, ImageView imageView, @DrawableRes int targetResId, @DrawableRes int loadingResId, @DrawableRes int failResId, int width, int height, final SobotImageLoader.SobotDisplayImageListener listener) {
        this.initImageLoader(context);
        DisplayImageOptions options = new DisplayImageOptions.Builder().showImageOnLoading(loadingResId).showImageOnFail(failResId).showImageForEmptyUri(failResId).cacheInMemory(true).bitmapConfig(Bitmap.Config.RGB_565).build();
        ImageSize imageSize = width != 0 || height != 0 ? new ImageSize(width, height) : null;
        ImageLoader.getInstance().displayImage("drawable://" + targetResId, (ImageAware)new ImageViewAware(imageView), options, imageSize, (ImageLoadingListener)new SimpleImageLoadingListener(){

            public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                if (listener != null) {
                    listener.onSuccess(view, imageUri);
                }
            }
        }, null);
    }
}

