/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.socrata.api.ContentEncoding;
import com.socrata.api.DatasetDestination;
import com.socrata.api.SodaRequestIdFilter;
import com.socrata.api.SodaTokenFilter;
import com.socrata.api.UserAgentFilter;
import com.socrata.exceptions.BadCompressionException;
import com.socrata.exceptions.ConflictOperationException;
import com.socrata.exceptions.DoesNotExistException;
import com.socrata.exceptions.InvalidLocationError;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.MalformedQueryError;
import com.socrata.exceptions.MetadataUpdateError;
import com.socrata.exceptions.MustBeLoggedInException;
import com.socrata.exceptions.QueryTimeoutException;
import com.socrata.exceptions.QueryTooComplexException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.SodaErrorResponse;
import com.socrata.model.requests.SodaRequest;
import com.socrata.utils.JacksonObjectMapperProvider;
import com.socrata.utils.ObjectMapperFactory;
import com.socrata.utils.streams.CompressingGzipInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class HttpLowLevel {
    private static final DateTimeFormatter RFC1123_DATE_FORMAT = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.UTC);
    private static final TypeReference<Map<String, Object>> GENERIC_JSON_OBJECT_TYPE = new TypeReference<Map<String, Object>>(){};
    protected static final int DEFAULT_MAX_RETRIES = 200;
    public static final long DEFAULT_RETRY_TIME = 4000L;
    protected static final int DEFAULT_STATUS_CHECK_ERROR_RETRIES = 5;
    protected static final long DEFAULT_STATUS_CHECK_ERROR_TIME = 4000L;
    public static final String SODA_VERSION = "$$version";
    public static final String NBE_FLAG = "nbe";
    public static final String SOCRATA_TOKEN_HEADER = "X-App-Token";
    public static final String SOCRATA_REQUEST_ID_HEADER = "X-Socrata-RequestId";
    public static final String USER_AGENT_HEADER = "User-Agent";
    public static final String AUTH_REQUIRED_CODE = "authentication_required";
    public static final String UNEXPECTED_ERROR = "uexpectedError";
    public static final String MALFORMED_RESPONSE = "malformedResponse";
    public static final Map<String, String> UTF_PARAMS = ImmutableMap.of((Object)"charset", (Object)"UTF-8");
    public static final MediaType JSON_TYPE = MediaType.APPLICATION_JSON_TYPE;
    public static final MediaType CSV_TYPE = new MediaType("text", "csv");
    public static final MediaType UTF8_TEXT_TYPE = new MediaType("text", "plain", UTF_PARAMS);
    public static final GenericType<List<Object>> MAP_OBJECT_TYPE = new GenericType<List<Object>>(){};
    private final ObjectMapper mapper;
    private final JerseyClient httpClient;
    private final JerseyClient apacheClient;
    private final String url;
    private long retryTime = 4000L;
    private long maxRetries = 200L;
    private ContentEncoding contentEncodingForUpserts = ContentEncoding.IDENTITY;
    private final ConcurrentHashMap<String, String> additionalParams = new ConcurrentHashMap();
    private int statusCheckErrorRetries = 5;
    private long statusCheckErrorTime = 4000L;

    private static JerseyClient createClient(boolean apache) {
        String proxyPortString;
        String proxyHost = System.getProperty("https.proxyHost");
        Integer proxyPort = null;
        if (StringUtils.isNotEmpty((CharSequence)proxyHost) && StringUtils.isNotEmpty((CharSequence)(proxyPortString = System.getProperty("https.proxyPort")))) {
            proxyPort = Integer.decode(proxyPortString);
        }
        return HttpLowLevel.createClient(proxyHost, proxyPort, apache);
    }

    private static JerseyClient createClient(@Nullable String proxyHost, @Nullable Integer proxyPort, boolean apache) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(JacksonObjectMapperProvider.class);
        clientConfig.register(JacksonFeature.class);
        clientConfig.register(MultiPartFeature.class);
        if (apache) {
            ApacheConnectorProvider cp = new ApacheConnectorProvider();
            if (StringUtils.isNotEmpty((CharSequence)proxyHost)) {
                String proxyUri = "https://" + proxyHost + ":" + (proxyPort == null ? 443 : proxyPort);
                System.out.println("SETTING PROXY URI to " + proxyUri);
                clientConfig.property("jersey.config.client.proxy.uri", (Object)proxyUri);
            }
            clientConfig.connectorProvider((ConnectorProvider)cp);
        } else {
            HttpUrlConnectorProvider cp = new HttpUrlConnectorProvider();
            clientConfig.connectorProvider((ConnectorProvider)cp);
            if (StringUtils.isNotEmpty((CharSequence)proxyHost)) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort == null ? 443 : proxyPort));
                cp.connectionFactory((HttpUrlConnectorProvider.ConnectionFactory)new ProxyHandler(proxy));
            }
        }
        return new JerseyClientBuilder().withConfig((Configuration)clientConfig).build();
    }

    public static final HttpLowLevel instantiate(@Nonnull String url) {
        return new HttpLowLevel(HttpLowLevel.createClient(false), HttpLowLevel.createClient(true), url);
    }

    public static final HttpLowLevel instantiateBasic(@Nonnull String url, @Nonnull String userName, @Nonnull String password, @Nullable String token, @Nullable String requestId) {
        return new HttpLowLevel(HttpLowLevel.createClientBasic(false, userName, password, token, requestId), HttpLowLevel.createClientBasic(true, userName, password, token, requestId), url);
    }

    private static JerseyClient createClientBasic(boolean apache, @Nonnull String userName, @Nonnull String password, @Nullable String token, @Nullable String requestId) {
        JerseyClient client = HttpLowLevel.createClient(apache);
        client.register((Object)HttpAuthenticationFeature.basic((String)userName, (String)password));
        if (token != null) {
            client.register((Object)new SodaTokenFilter(token));
        }
        if (requestId != null) {
            client.register((Object)new SodaRequestIdFilter(requestId));
        }
        client.register((Object)new UserAgentFilter());
        client.property("jersey.config.client.connectTimeout", (Object)1000);
        client.property("jersey.config.client.readTimeout", (Object)6000000);
        return client;
    }

    @Deprecated
    public HttpLowLevel(JerseyClient client, String url) {
        this(client, client, url, ObjectMapperFactory.create());
    }

    private HttpLowLevel(JerseyClient httpClient, JerseyClient apacheClient, String url) {
        this(httpClient, apacheClient, url, ObjectMapperFactory.create());
    }

    @Deprecated
    public HttpLowLevel(JerseyClient client, String url, ObjectMapper mapper) {
        this(client, client, url, mapper);
    }

    private HttpLowLevel(JerseyClient httpClient, JerseyClient apacheClient, String url, ObjectMapper mapper) {
        this.httpClient = httpClient;
        this.apacheClient = apacheClient;
        this.url = url;
        this.mapper = mapper;
    }

    public JerseyClient getClient() {
        return this.apacheClient;
    }

    public long getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(long retryTime) {
        this.retryTime = retryTime;
    }

    public long getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(long maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getStatusCheckErrorRetries() {
        return this.statusCheckErrorRetries;
    }

    public void setStatusCheckErrorRetries(int statusCheckErrorRetries) {
        this.statusCheckErrorRetries = statusCheckErrorRetries;
    }

    public long getStatusCheckErrorTime() {
        return this.statusCheckErrorTime;
    }

    public void setStatusCheckErrorTime(int statusCheckErrorTime) {
        this.statusCheckErrorTime = statusCheckErrorTime;
    }

    public ContentEncoding getContentEncodingForUpserts() {
        return this.contentEncodingForUpserts;
    }

    public void setContentEncodingForUpserts(ContentEncoding contentEncodingForUpserts) {
        this.contentEncodingForUpserts = contentEncodingForUpserts;
    }

    public Map<String, String> getAdditionalParameters() {
        return this.additionalParams;
    }

    public UriBuilder uriBuilder() {
        return UriBuilder.fromUri((String)this.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response follow202(URI uri, MediaType mediaType, long retryTime, SodaRequest request2Rerun) throws InterruptedException, LongRunningQueryException, SodaError {
        if (retryTime > 0L) {
            HttpLowLevel httpLowLevel = this;
            synchronized (httpLowLevel) {
                this.wait(retryTime);
            }
        }
        if (uri != null) {
            return this.queryRaw(uri, mediaType);
        }
        return request2Rerun.issueRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T getAsyncResults(URI uri, long waitTime, long numRetries, Class<T> cls, SodaRequest request2Rerun) throws SodaError, InterruptedException {
        try (Response response = this.getAsyncResults(uri, JSON_TYPE, waitTime, numRetries, request2Rerun);){
            Object object = response.readEntity(cls);
            return (T)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T getAsyncResults(URI uri, MediaType mediaType, long waitTime, long numRetries, GenericType<T> cls, SodaRequest request2Rerun) throws SodaError, InterruptedException {
        try (Response response = this.getAsyncResults(uri, mediaType, waitTime, numRetries, request2Rerun);){
            Object object = response.readEntity(cls);
            return (T)object;
        }
    }

    public final Response getAsyncResults(URI uri, MediaType mediaType, long waitTime, long numRetries, SodaRequest request2Rerun) throws SodaError, InterruptedException {
        int i = 0;
        while ((long)i < numRetries) {
            try {
                return this.follow202(uri, mediaType, waitTime, request2Rerun);
            }
            catch (LongRunningQueryException e) {
                if (e.location != null) {
                    uri = e.location;
                }
                ++i;
            }
        }
        throw new SodaError("Long running result did not complete within the allotted time.");
    }

    public Response deleteRaw(URI uri) throws LongRunningQueryException, SodaError {
        Response response = (Response)this.apacheClient.target(this.soda2ifyUri(uri)).request().accept(new String[]{"application/json"}).delete(Response.class);
        return this.processErrors(response);
    }

    public Response queryRaw(URI uri, MediaType acceptType) throws LongRunningQueryException, SodaError {
        Response response = (Response)this.apacheClient.target(this.soda2ifyUri(uri)).request().accept(new MediaType[]{acceptType}).get(Response.class);
        return this.processErrors(response);
    }

    public Response postRaw(URI uri, MediaType mediaType, ContentEncoding contentEncoding, Object object) throws LongRunningQueryException, SodaError {
        return this.postRaw(uri, mediaType, MediaType.APPLICATION_JSON_TYPE, contentEncoding, object, null);
    }

    public Response postRaw(URI uri, MediaType mediaType, ContentEncoding contentEncoding, Object object, String filename) throws LongRunningQueryException, SodaError {
        return this.postRaw(uri, mediaType, MediaType.APPLICATION_JSON_TYPE, contentEncoding, object, filename);
    }

    public Response postRaw(URI uri, MediaType mediaType, MediaType acceptType, ContentEncoding contentEncoding, Object object) throws LongRunningQueryException, SodaError {
        return this.postRaw(uri, mediaType, acceptType, contentEncoding, object, null);
    }

    public Response postRaw(URI uri, MediaType mediaType, MediaType acceptType, ContentEncoding contentEncoding, Object object, String filename) throws LongRunningQueryException, SodaError {
        JerseyInvocation.Builder builder = this.apacheClient.target(this.soda2ifyUri(uri)).request().accept(new MediaType[]{acceptType});
        if (filename != null) {
            builder = builder.header("X-File-Name", (Object)filename);
        }
        Object encodedObject = this.streamContents(this.encodeContents(contentEncoding, builder, object));
        Response response = (Response)builder.post(Entity.entity((Object)encodedObject, (MediaType)mediaType), Response.class);
        return this.processErrors(response);
    }

    public void setUseNewBackend(boolean useNbe) {
        if (useNbe) {
            this.setDatasetDestination(DatasetDestination.NBE);
        } else {
            this.setDatasetDestination(null);
        }
    }

    public void setDatasetDestination(DatasetDestination destination) {
        if (destination == null) {
            this.additionalParams.remove(NBE_FLAG);
        } else {
            this.additionalParams.put(NBE_FLAG, Boolean.toString(destination == DatasetDestination.NBE));
        }
    }

    private Object streamContents(final Object object) {
        if (object instanceof InputStream) {
            return new StreamingOutput(){
                final InputStream stream;
                {
                    this.stream = (InputStream)object;
                }

                public void write(OutputStream outputStream) throws IOException {
                    int count;
                    byte[] buf = new byte[10240];
                    while ((count = this.stream.read(buf)) > 0) {
                        outputStream.write(buf, 0, count);
                    }
                }
            };
        }
        return object;
    }

    private Object encodeContents(ContentEncoding contentEncoding, JerseyInvocation.Builder builder, Object object) throws BadCompressionException {
        switch (contentEncoding) {
            case GZIP: {
                builder.header("Content-Encoding", (Object)contentEncoding.header);
                if (!(object instanceof InputStream)) {
                    throw new IllegalArgumentException("Can only compress puts that use an InputStream");
                }
                try {
                    return new CompressingGzipInputStream((InputStream)object);
                }
                catch (IOException ioe) {
                    throw new BadCompressionException(ioe);
                }
            }
            case IDENTITY: {
                return object;
            }
        }
        throw new IllegalArgumentException("Unknown ContentEncoding");
    }

    public Response postFileRaw(URI uri, MediaType mediaType, File file) throws LongRunningQueryException, SodaError {
        return this.postFileRaw(uri, mediaType, MediaType.APPLICATION_JSON_TYPE, file);
    }

    public Response postFileRaw(URI uri, MediaType mediaType, MediaType acceptType, File file) throws LongRunningQueryException, SodaError {
        Response response;
        try (FormDataMultiPart form = new FormDataMultiPart();){
            form.bodyPart((BodyPart)new FileDataBodyPart(file.getName(), file, mediaType));
            response = (Response)this.httpClient.target(this.soda2ifyUri(uri)).request().accept(new MediaType[]{acceptType}).post(Entity.entity((Object)form, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), Response.class);
        }
        catch (IOException e) {
            throw new SodaError("IO error", e);
        }
        return this.processErrors(response);
    }

    public <T> Response putRaw(URI uri, MediaType mediaType, ContentEncoding contentEncoding, Object object) throws LongRunningQueryException, SodaError {
        JerseyInvocation.Builder builder = this.apacheClient.target(this.soda2ifyUri(uri)).request().accept(new String[]{"application/json"});
        Object encodedObject = this.streamContents(this.encodeContents(contentEncoding, builder, object));
        Response response = (Response)builder.put(Entity.entity((Object)encodedObject, (MediaType)mediaType), Response.class);
        return this.processErrors(response);
    }

    public Response putFileRaw(URI uri, MediaType mediaType, File file) throws LongRunningQueryException, SodaError {
        return this.putFileRaw(uri, mediaType, MediaType.APPLICATION_JSON_TYPE, file);
    }

    public Response putFileRaw(URI uri, MediaType mediaType, MediaType acceptType, File file) throws LongRunningQueryException, SodaError {
        Response response;
        try (FormDataMultiPart form = new FormDataMultiPart();){
            form.bodyPart((BodyPart)new FileDataBodyPart(file.getName(), file, mediaType));
            response = (Response)this.httpClient.target(this.soda2ifyUri(uri)).request().accept(new MediaType[]{acceptType}).put(Entity.entity((Object)form, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE), Response.class);
        }
        catch (IOException e) {
            throw new SodaError("IO error", e);
        }
        return this.processErrors(response);
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        if (this.apacheClient != null) {
            this.apacheClient.close();
        }
    }

    ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    private URI soda2ifyUri(URI uri) {
        UriBuilder builder = UriBuilder.fromUri((URI)uri).queryParam(SODA_VERSION, new Object[]{"2.0"});
        for (String key : this.additionalParams.keySet()) {
            builder.queryParam(key, new Object[]{this.additionalParams.get(key)});
        }
        return builder.build(new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Response processErrors(Response response) throws SodaError, LongRunningQueryException {
        int status = response.getStatus();
        if (status == 200 || status == 201 || status == 204) {
            return response;
        }
        try {
            SodaErrorResponse sodaErrorResponse;
            String body = (String)response.readEntity(String.class);
            if (status == 202) {
                String location = (String)response.getStringHeaders().getFirst((Object)"Location");
                String retryAfter = (String)response.getStringHeaders().getFirst((Object)"Retry-After");
                String ticket = null;
                URI locationUri = null;
                if (StringUtils.isEmpty((CharSequence)location)) {
                    if (StringUtils.isEmpty((CharSequence)body)) {
                        throw new SodaError("Illegal body for 202 response.  No location and body is empty.");
                    }
                    try {
                        Map bodyProperties = (Map)this.mapper.readValue(body, GENERIC_JSON_OBJECT_TYPE);
                        if (bodyProperties.get("ticket") == null) throw new LongRunningQueryException(locationUri, this.parseRetryAfter(retryAfter), ticket);
                        ticket = bodyProperties.get("ticket").toString();
                        throw new LongRunningQueryException(locationUri, this.parseRetryAfter(retryAfter), ticket);
                    }
                    catch (IOException ioe) {
                        throw new SodaError("Illegal body for 202 response.  No location or ticket.  Body = " + body);
                    }
                }
                try {
                    locationUri = new URI(location);
                    throw new LongRunningQueryException(locationUri, this.parseRetryAfter(retryAfter), ticket);
                }
                catch (URISyntaxException e) {
                    throw new InvalidLocationError(location);
                }
            }
            if (response.getMediaType() != null && !response.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                throw new SodaError(new SodaErrorResponse(UNEXPECTED_ERROR, body, null, null), status);
            }
            if (body.isEmpty()) {
                sodaErrorResponse = new SodaErrorResponse(String.valueOf(status), null, null, null);
            } else {
                try {
                    sodaErrorResponse = (SodaErrorResponse)this.mapper.readValue(body, SodaErrorResponse.class);
                }
                catch (Exception e) {
                    throw new SodaError(new SodaErrorResponse(MALFORMED_RESPONSE, body, null, null), status);
                }
            }
            switch (status) {
                case 400: {
                    if (sodaErrorResponse.message == null || !sodaErrorResponse.message.startsWith("Row data was saved.")) throw new MalformedQueryError(sodaErrorResponse);
                    throw new MetadataUpdateError(sodaErrorResponse);
                }
                case 403: {
                    if (!AUTH_REQUIRED_CODE.equals(sodaErrorResponse.code)) throw new QueryTooComplexException(sodaErrorResponse);
                    throw new MustBeLoggedInException(sodaErrorResponse);
                }
                case 404: {
                    throw new DoesNotExistException(sodaErrorResponse);
                }
                case 408: {
                    throw new QueryTimeoutException(sodaErrorResponse);
                }
                case 409: {
                    throw new ConflictOperationException(sodaErrorResponse);
                }
            }
            throw new SodaError(sodaErrorResponse, status);
        }
        catch (Throwable throwable) {
            response.close();
            throw throwable;
        }
    }

    private long parseRetryAfter(String retryAfter) {
        if (retryAfter == null) {
            return this.getRetryTime();
        }
        if (StringUtils.isNumeric((CharSequence)retryAfter)) {
            return System.currentTimeMillis() + (long)Integer.parseInt(retryAfter) * 1000L;
        }
        try {
            DateTime date = RFC1123_DATE_FORMAT.parseDateTime(retryAfter);
            if (date == null) {
                return this.getRetryTime();
            }
            return date.getMillis();
        }
        catch (Exception e) {
            return this.getRetryTime();
        }
    }

    private static class ProxyHandler
    implements HttpUrlConnectorProvider.ConnectionFactory {
        final Proxy proxy;

        public ProxyHandler(@Nonnull Proxy proxy) {
            this.proxy = proxy;
        }

        public HttpURLConnection getConnection(URL url) throws IOException {
            return (HttpURLConnection)url.openConnection(this.proxy);
        }
    }
}

