/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.socrata.api.HttpLowLevel;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.LongRunningRequestStatusCheckException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.requests.SodaRequest;
import javax.ws.rs.ProcessingException;

public class LongRunningRequest<T, R> {
    private LongRunningQueryException longRunningQueryException;
    private SodaRequest<T> sodaRequest;
    private Class<R> cls;

    public LongRunningRequest(LongRunningQueryException longRunningQueryException, Class<R> cls, SodaRequest<T> sodaRequest) {
        this.longRunningQueryException = longRunningQueryException;
        this.sodaRequest = sodaRequest;
        this.cls = cls;
    }

    public R checkStatus(HttpLowLevel httpLowLevel, int retries, long intervalMs) throws SodaError, InterruptedException {
        for (int i = 0; i <= retries; ++i) {
            block5: {
                try {
                    return httpLowLevel.getAsyncResults(this.longRunningQueryException.location, this.longRunningQueryException.timeToRetry, Integer.MAX_VALUE, this.cls, this.sodaRequest);
                }
                catch (ProcessingException exception) {
                    if (i >= retries) {
                        throw new LongRunningRequestStatusCheckException(exception, this);
                    }
                }
                catch (SodaError sodaError) {
                    if (i < retries) break block5;
                    sodaError.setLongRunningRequest(this);
                    throw sodaError;
                }
            }
            Thread.sleep(intervalMs);
        }
        throw new IllegalArgumentException("Argument - retires must be >= 0");
    }
}

