/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.socrata.api.ContentEncoding;
import com.socrata.api.HttpLowLevel;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.soql.SoqlQuery;
import com.socrata.utils.RowUpdateOption;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class Soda2Base {
    public static final String SODA_BASE_PATH = "resource";
    public static final String SODA_QUERY = "$query";
    private final HttpLowLevel httpLowLevel;

    public Soda2Base(HttpLowLevel httpLowLevel) {
        this.httpLowLevel = httpLowLevel;
    }

    public Response query(String resourceId, MediaType mediaType, SoqlQuery query) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        return this.httpLowLevel.queryRaw(query.toSodaUri(builder).build(new Object[0]), mediaType);
    }

    public Response query(String resourceId, MediaType mediaType, String query) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId).queryParam(SODA_QUERY, new Object[]{query});
        return this.httpLowLevel.queryRaw(builder.build(new Object[0]), mediaType);
    }

    public Response getById(String resourceId, MediaType mediaType, String uniqueId) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId).path(uniqueId);
        return this.httpLowLevel.queryRaw(builder.build(new Object[0]), mediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response doTruncate(String resourceId) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("[]".getBytes(StandardCharsets.UTF_8));
        try {
            Response response = this.httpLowLevel.putRaw(builder.build(new Object[0]), MediaType.APPLICATION_JSON_TYPE, this.httpLowLevel.getContentEncodingForUpserts(), inputStream);
            return response;
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public Response doDelete(String resourceId, String uniqueId) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId).path(uniqueId);
        return this.httpLowLevel.deleteRaw(builder.build(new Object[0]));
    }

    public <T> Response doAdd(String resourceId, T object) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        return this.httpLowLevel.postRaw(builder.build(new Object[0]), HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, object);
    }

    public <T> Response doAddObjects(String resourceId, Collection<T> objects) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        return this.httpLowLevel.postRaw(builder.build(new Object[0]), HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, objects);
    }

    public Response doAddStream(String resourceId, MediaType mediaType, InputStream stream) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        return this.httpLowLevel.postRaw(builder.build(new Object[0]), mediaType, this.httpLowLevel.getContentEncodingForUpserts(), stream);
    }

    public Response doAddStream(String resourceId, MediaType mediaType, InputStream stream, RowUpdateOption options) throws LongRunningQueryException, SodaError {
        UriBuilder builder = options.addToRequest(this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId));
        return this.httpLowLevel.postRaw(builder.build(new Object[0]), mediaType, this.httpLowLevel.getContentEncodingForUpserts(), stream);
    }

    public Response doUpdate(String resourceId, Object uniqueId, Object object) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId).path(uniqueId.toString());
        return this.httpLowLevel.postRaw(builder.build(new Object[0]), HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, object);
    }

    public <T> Response doReplaceObjects(String resourceId, Collection<T> objects) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        return this.httpLowLevel.putRaw(builder.build(new Object[0]), HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, objects);
    }

    public Response doReplaceStream(String resourceId, MediaType mediaType, InputStream stream) throws LongRunningQueryException, SodaError {
        UriBuilder builder = this.httpLowLevel.uriBuilder().path(SODA_BASE_PATH).path(resourceId);
        return this.httpLowLevel.putRaw(builder.build(new Object[0]), mediaType, this.httpLowLevel.getContentEncodingForUpserts(), stream);
    }

    public final HttpLowLevel getHttpLowLevel() {
        return this.httpLowLevel;
    }

    public void close() {
        this.httpLowLevel.close();
    }
}

