/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.socrata.api.HttpLowLevel;
import com.socrata.api.Soda2Base;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.requests.SodaRequest;
import com.socrata.model.soql.SoqlQuery;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class Soda2Consumer
extends Soda2Base {
    public static final GenericType<List<Object>> HASH_RETURN_TYPE = new GenericType<List<Object>>(){};

    public static final Soda2Consumer newConsumer(String url) {
        return new Soda2Consumer(HttpLowLevel.instantiate(url));
    }

    public static final Soda2Consumer newConsumer(String url, String userName, String password, String token) {
        return new Soda2Consumer(HttpLowLevel.instantiateBasic(url, userName, password, token, null));
    }

    public Soda2Consumer(HttpLowLevel httpLowLevel) {
        super(httpLowLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getById(String resourceId, String id, Class<T> cls) throws SodaError, InterruptedException {
        SodaRequest<String> requester = new SodaRequest<String>(resourceId, id){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Consumer.this.getById(this.resourceId, HttpLowLevel.JSON_TYPE, (String)this.payload);
            }
        };
        try (Response response = requester.issueRequest();){
            Object object = response.readEntity(cls);
            return (T)object;
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), new GenericType(cls), requester);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> query(String resourceId, SoqlQuery query, GenericType<List<T>> genericType) throws SodaError, InterruptedException {
        List list;
        SodaRequest<SoqlQuery> requester = new SodaRequest<SoqlQuery>(resourceId, query){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Consumer.this.query(this.resourceId, HttpLowLevel.JSON_TYPE, (SoqlQuery)this.payload);
            }
        };
        Response response = this.query(resourceId, HttpLowLevel.JSON_TYPE, query);
        try {
            list = (List)response.readEntity(genericType);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), genericType, requester);
            }
        }
        response.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> query(String resourceId, String query, GenericType<List<T>> genericType) throws SodaError, InterruptedException {
        List list;
        SodaRequest<String> requester = new SodaRequest<String>(resourceId, query){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Consumer.this.query(this.resourceId, HttpLowLevel.JSON_TYPE, (String)this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            list = (List)response.readEntity(genericType);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), genericType, requester);
            }
        }
        response.close();
        return list;
    }
}

