/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.socrata.api.HttpLowLevel;
import com.socrata.api.Soda2Consumer;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.Meta;
import com.socrata.model.UpsertError;
import com.socrata.model.UpsertResult;
import com.socrata.model.requests.SodaModRequest;
import com.socrata.model.requests.SodaRequest;
import com.socrata.model.requests.SodaTypedRequest;
import com.socrata.utils.GeneralUtils;
import com.socrata.utils.RowUpdateOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class Soda2Producer
extends Soda2Consumer {
    private final JsonFactory factory;

    public static final Soda2Producer newProducer(String url, String userName, String password, String token) {
        return new Soda2Producer(HttpLowLevel.instantiateBasic(url, userName, password, token, null));
    }

    public static final Soda2Producer newProducerWithRequestId(String url, String userName, String password, String token, String requestId) {
        return new Soda2Producer(HttpLowLevel.instantiateBasic(url, userName, password, token, requestId));
    }

    public Soda2Producer(HttpLowLevel httpLowLevel) {
        super(httpLowLevel);
        this.factory = httpLowLevel.getObjectMapper().getFactory();
    }

    public void truncate(String resourceId) throws SodaError, InterruptedException {
        SodaRequest<String> requester = new SodaRequest<String>(resourceId, null){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Producer.this.doTruncate(this.resourceId);
            }
        };
        try {
            requester.issueRequest().close();
        }
        catch (LongRunningQueryException e) {
            this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), new GenericType(String.class), requester);
        }
    }

    public void delete(String resourceId, String id) throws SodaError, InterruptedException {
        SodaRequest<String> requester = new SodaRequest<String>(resourceId, id){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Producer.this.doDelete(this.resourceId, (String)this.payload);
            }
        };
        try {
            requester.issueRequest().close();
        }
        catch (LongRunningQueryException e) {
            this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), new GenericType(String.class), requester);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Meta addObject(String resourceId, T object) throws SodaError, InterruptedException {
        Meta meta;
        SodaRequest requester = new SodaRequest<T>(resourceId, object){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Producer.this.doAdd(this.resourceId, this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            meta = (Meta)response.readEntity(Meta.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), Meta.class, requester);
            }
        }
        response.close();
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T addObject(String resourceId, T object, Class<T> retType) throws SodaError, InterruptedException {
        SodaRequest requester = new SodaRequest<T>(resourceId, object){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Producer.this.doAdd(this.resourceId, this.payload);
            }
        };
        try (Response response = requester.issueRequest();){
            Object object2 = response.readEntity(retType);
            return (T)object2;
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), retType, requester);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> UpsertResult upsert(String resourceId, List<T> objects) throws SodaError, InterruptedException {
        UpsertResult upsertResult;
        SodaRequest requester = new SodaRequest<List<T>>(resourceId, objects){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Producer.this.doAddObjects(this.resourceId, (Collection)this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            upsertResult = this.deserializeUpsertResult(response);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), UpsertResult.class, requester);
            }
            catch (IOException ioe) {
                throw new SodaError("Error upserting a dataset from this list of objects.  Error message: " + ioe.getLocalizedMessage());
            }
        }
        response.close();
        return upsertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> UpsertResult replace(String resourceId, List<T> objects) throws SodaError, InterruptedException {
        UpsertResult upsertResult;
        SodaRequest requester = new SodaRequest<List<T>>(resourceId, objects){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Producer.this.doReplaceObjects(this.resourceId, (Collection)this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            upsertResult = this.deserializeUpsertResult(response);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), UpsertResult.class, requester);
            }
            catch (IOException ioe) {
                throw new SodaError("Error replacing dataset from this list of objects.  Error message: " + ioe.getLocalizedMessage());
            }
        }
        response.close();
        return upsertResult;
    }

    public UpsertResult upsertStream(String resourceId, MediaType mediaType, InputStream stream) throws SodaError, InterruptedException {
        return this.upsertStream(resourceId, mediaType, stream, new RowUpdateOption());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpsertResult upsertStream(String resourceId, MediaType mediaType, InputStream stream, RowUpdateOption rowUpdateOption) throws SodaError, InterruptedException {
        UpsertResult upsertResult;
        SodaTypedRequest<InputStream> requester = new SodaTypedRequest<InputStream>(resourceId, stream, mediaType, rowUpdateOption){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Producer.this.doAddStream(this.resourceId, this.mediaType, (InputStream)this.payload, this.rowUpdateOption);
            }
        };
        Response response = requester.issueRequest();
        try {
            upsertResult = this.deserializeUpsertResult(response);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return (UpsertResult)this.getHttpLowLevel().getAsyncResults(e.location, mediaType, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), new GenericType(InputStream.class), requester);
            }
            catch (IOException ioe) {
                throw new SodaError("Error upserting a dataset from this stream.  Error message: " + ioe.getLocalizedMessage());
            }
        }
        response.close();
        return upsertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpsertResult replaceStream(String resourceId, MediaType mediaType, InputStream stream) throws SodaError, InterruptedException {
        UpsertResult upsertResult;
        SodaTypedRequest<InputStream> requester = new SodaTypedRequest<InputStream>(resourceId, stream, mediaType){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Producer.this.doReplaceStream(this.resourceId, this.mediaType, (InputStream)this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            upsertResult = this.deserializeUpsertResult(response);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return (UpsertResult)this.getHttpLowLevel().getAsyncResults(e.location, mediaType, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), new GenericType(InputStream.class), requester);
            }
            catch (IOException ioe) {
                throw new SodaError("Error replacing a dataset from this stream.  Error message: " + ioe.getLocalizedMessage());
            }
        }
        response.close();
        return upsertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public UpsertResult upsertCsv(String resourceId, File csvFile) throws SodaError, InterruptedException {
        try {
            FileInputStream is = new FileInputStream(csvFile);
            SodaTypedRequest<InputStream> requester = new SodaTypedRequest<InputStream>(resourceId, (InputStream)is, HttpLowLevel.CSV_TYPE){

                @Override
                public Response issueRequest() throws LongRunningQueryException, SodaError {
                    return Soda2Producer.this.doAddStream(this.resourceId, this.mediaType, (InputStream)this.payload);
                }
            };
            try {
                UpsertResult upsertResult;
                Response response = requester.issueRequest();
                try {
                    upsertResult = this.deserializeUpsertResult(response);
                }
                catch (Throwable throwable) {
                    try {
                        response.close();
                        throw throwable;
                    }
                    catch (LongRunningQueryException e) {
                        UpsertResult upsertResult2 = (UpsertResult)this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.CSV_TYPE, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), new GenericType(InputStream.class), requester);
                        return upsertResult2;
                    }
                }
                response.close();
                return upsertResult;
            }
            finally {
                GeneralUtils.closeQuietly(is);
            }
        }
        catch (IOException ioe) {
            throw new SodaError("Cannot load CSV from the file " + GeneralUtils.bestFilePath(csvFile) + ".  Error message: " + ioe.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public UpsertResult replaceCsv(String resourceId, File csvFile) throws SodaError, InterruptedException {
        try {
            FileInputStream is = new FileInputStream(csvFile);
            SodaTypedRequest<InputStream> requester = new SodaTypedRequest<InputStream>(resourceId, (InputStream)is, HttpLowLevel.CSV_TYPE){

                @Override
                public Response issueRequest() throws LongRunningQueryException, SodaError {
                    return Soda2Producer.this.doReplaceStream(this.resourceId, this.mediaType, (InputStream)this.payload);
                }
            };
            try {
                UpsertResult upsertResult;
                Response response = requester.issueRequest();
                try {
                    upsertResult = this.deserializeUpsertResult(response);
                }
                catch (Throwable throwable) {
                    try {
                        response.close();
                        throw throwable;
                    }
                    catch (LongRunningQueryException e) {
                        UpsertResult upsertResult2 = (UpsertResult)this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.CSV_TYPE, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), new GenericType(InputStream.class), requester);
                        return upsertResult2;
                    }
                }
                response.close();
                return upsertResult;
            }
            finally {
                GeneralUtils.closeQuietly(is);
            }
        }
        catch (IOException ioe) {
            throw new SodaError("Cannot load CSV from the file " + GeneralUtils.bestFilePath(csvFile) + ".  Error message: " + ioe.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Meta update(String resourceId, Object id, T object) throws SodaError, InterruptedException {
        Meta meta;
        SodaModRequest requester = new SodaModRequest<T>(resourceId, object, id){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return Soda2Producer.this.doUpdate(this.resourceId, this.id, this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            meta = (Meta)response.readEntity(Meta.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return (Meta)this.getHttpLowLevel().getAsyncResults(e.location, HttpLowLevel.JSON_TYPE, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), new GenericType(Meta.class), requester);
            }
        }
        response.close();
        return meta;
    }

    UpsertResult deserializeUpsertResult(InputStream is, Long truthDataVersion) throws IOException {
        JsonParser parser = this.factory.createParser(is);
        if (parser.nextToken() == JsonToken.START_ARRAY) {
            int count = 0;
            long inserts = 0L;
            long updates = 0L;
            long deletes = 0L;
            LinkedList<UpsertError> errors = new LinkedList<UpsertError>();
            JsonToken currToken = parser.nextToken();
            if (currToken == JsonToken.START_ARRAY) {
                currToken = parser.nextToken();
            }
            while (currToken != JsonToken.END_ARRAY) {
                NewUpsertRow row = (NewUpsertRow)parser.readValueAs(NewUpsertRow.class);
                if ("insert".equals(row.typ)) {
                    ++inserts;
                } else if ("update".equals(row.typ)) {
                    ++updates;
                } else if ("delete".equals(row.typ)) {
                    ++deletes;
                } else if ("error".equals(row.typ)) {
                    errors.add(new UpsertError(row.err, count, row.id));
                }
                ++count;
                currToken = parser.nextToken();
            }
            return new UpsertResult(inserts, updates, deletes, errors.size() > 0 ? errors : null, truthDataVersion);
        }
        return (UpsertResult)parser.readValueAs(UpsertResult.class);
    }

    UpsertResult deserializeUpsertResult(Response response) throws IOException {
        Long truthDataVersion = null;
        try {
            Object header = response.getHeaders().getFirst((Object)"X-SODA2-Truth-Version");
            if (header != null) {
                truthDataVersion = Long.parseLong(header.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.deserializeUpsertResult((InputStream)response.readEntity(InputStream.class), truthDataVersion);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NewUpsertRow {
        public final String typ;
        public final String id;
        public final String ver;
        public final String err;

        @JsonCreator
        public NewUpsertRow(@JsonProperty(value="typ") String typ, @JsonProperty(value="id") String id, @JsonProperty(value="ver") String ver, @JsonProperty(value="err") String err) {
            this.typ = typ;
            this.id = id;
            this.ver = ver;
            this.err = err;
        }
    }
}

