/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Preconditions;
import com.socrata.api.ContentEncoding;
import com.socrata.api.DatasetDestination;
import com.socrata.api.HttpLowLevel;
import com.socrata.api.SodaWorkflow;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.SearchResults;
import com.socrata.model.importer.AssetResponse;
import com.socrata.model.importer.Column;
import com.socrata.model.importer.Dataset;
import com.socrata.model.importer.DatasetInfo;
import com.socrata.model.importer.NonDataFileDataset;
import com.socrata.model.requests.SodaRequest;
import com.socrata.model.search.SearchClause;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class SodaDdl
extends SodaWorkflow {
    protected static final String COLUMNS_PATH = "columns";
    protected static final String ASSET_BASE_PATH = "assets";
    protected static final String FILE_RESOURCE_PATH = "file_data";
    protected static final String SEARCH_BASE_PATH = "search";
    private final URI assetUri;
    private final URI fileResourceUri;
    private final URI searchUri;

    public static final SodaDdl newDdl(String url, String userName, String password, String token) {
        return new SodaDdl(HttpLowLevel.instantiateBasic(url, userName, password, token, null));
    }

    public SodaDdl(HttpLowLevel httpLowLevel) {
        super(httpLowLevel);
        this.assetUri = httpLowLevel.uriBuilder().path("api").path(ASSET_BASE_PATH).build(new Object[0]);
        this.searchUri = httpLowLevel.uriBuilder().path("api").path(SEARCH_BASE_PATH).path("views").build(new Object[0]);
        this.fileResourceUri = httpLowLevel.uriBuilder().path("api").path(FILE_RESOURCE_PATH).build(new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResults searchViews(SearchClause ... searchClauses) throws SodaError, InterruptedException {
        SearchResults searchResults;
        UriBuilder searchBuilder = UriBuilder.fromUri((URI)this.searchUri);
        for (SearchClause clause : searchClauses) {
            searchBuilder.queryParam(clause.getQueryParamName(), new Object[]{clause.getValue()});
        }
        searchBuilder.queryParam("limit", new Object[]{200});
        SodaRequest<URI> requester = new SodaRequest<URI>(null, searchBuilder.build(new Object[0])){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return SodaDdl.this.httpLowLevel.queryRaw((URI)this.payload, MediaType.APPLICATION_JSON_TYPE);
            }
        };
        Response response = requester.issueRequest();
        try {
            searchResults = (SearchResults)response.readEntity(SearchResults.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, MediaType.APPLICATION_JSON_TYPE, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), new GenericType<SearchResults>(){}, requester);
            }
        }
        response.close();
        return searchResults;
    }

    public DatasetInfo createDataset(DatasetInfo dataset) throws SodaError, InterruptedException {
        return this.createDataset(dataset, false);
    }

    public DatasetInfo createDataset(DatasetInfo dataset, boolean useNewBackend) throws SodaError, InterruptedException {
        return this.createDataset(dataset, useNewBackend ? DatasetDestination.NBE : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetInfo createDataset(DatasetInfo dataset, final DatasetDestination destination) throws SodaError, InterruptedException {
        DatasetInfo datasetInfo;
        SodaRequest<DatasetInfo> requester = new SodaRequest<DatasetInfo>(null, dataset){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                SodaDdl.this.httpLowLevel.setDatasetDestination(destination);
                return SodaDdl.this.httpLowLevel.postRaw(SodaDdl.this.viewUri, HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            datasetInfo = (DatasetInfo)response.readEntity(DatasetInfo.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), DatasetInfo.class, (SodaRequest)requester);
            }
        }
        response.close();
        return datasetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetInfo loadDatasetInfo(String id) throws SodaError, InterruptedException {
        DatasetInfo datasetInfo;
        URI uri = UriBuilder.fromUri((URI)this.viewUri).path(id).build(new Object[0]);
        SodaRequest<URI> requester = new SodaRequest<URI>(null, uri){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return SodaDdl.this.httpLowLevel.queryRaw((URI)this.payload, HttpLowLevel.JSON_TYPE);
            }
        };
        Response response = this.httpLowLevel.queryRaw(uri, HttpLowLevel.JSON_TYPE);
        try {
            datasetInfo = (DatasetInfo)response.readEntity(DatasetInfo.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), DatasetInfo.class, (SodaRequest)requester);
            }
        }
        response.close();
        return datasetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetInfo updateDatasetInfo(DatasetInfo datasetInfo) throws SodaError, InterruptedException {
        DatasetInfo datasetInfo2;
        SodaRequest<DatasetInfo> requester = new SodaRequest<DatasetInfo>(datasetInfo.getId(), datasetInfo){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI uri = UriBuilder.fromUri((URI)SodaDdl.this.viewUri).path(this.resourceId).build(new Object[0]);
                return SodaDdl.this.httpLowLevel.putRaw(uri, HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            datasetInfo2 = (DatasetInfo)response.readEntity(DatasetInfo.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), DatasetInfo.class, (SodaRequest)requester);
            }
        }
        response.close();
        return datasetInfo2;
    }

    public void deleteDataset(final String id) throws SodaError, InterruptedException {
        SodaRequest<DatasetInfo> requester = new SodaRequest<DatasetInfo>(id, null){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI uri = UriBuilder.fromUri((URI)SodaDdl.this.viewUri).path(id).build(new Object[0]);
                return SodaDdl.this.httpLowLevel.deleteRaw(uri);
            }
        };
        try {
            requester.issueRequest().close();
        }
        catch (LongRunningQueryException e) {
            this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), Dataset.class, (SodaRequest)requester);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column addColumn(String datasetId, Column column) throws SodaError, InterruptedException {
        Column column2;
        SodaRequest<Column> requester = new SodaRequest<Column>(datasetId, column){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI uri = UriBuilder.fromUri((URI)SodaDdl.this.viewUri).path(this.resourceId).path(SodaDdl.COLUMNS_PATH).build(new Object[0]);
                return SodaDdl.this.httpLowLevel.postRaw(uri, HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            column2 = (Column)response.readEntity(Column.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), Column.class, (SodaRequest)requester);
            }
        }
        response.close();
        return column2;
    }

    public void removeColumn(String datasetId, int columnId) throws LongRunningQueryException, SodaError {
        URI uri = UriBuilder.fromUri((URI)this.viewUri).path(datasetId).path(COLUMNS_PATH).path(Integer.toString(columnId)).build(new Object[0]);
        this.httpLowLevel.deleteRaw(uri).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column alterColumn(String datasetId, Column column) throws SodaError, InterruptedException {
        Column column2;
        SodaRequest<Column> requester = new SodaRequest<Column>(datasetId, column){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI uri = UriBuilder.fromUri((URI)SodaDdl.this.viewUri).path(this.resourceId).path(SodaDdl.COLUMNS_PATH).path(Integer.toString(((Column)this.payload).getId())).build(new Object[0]);
                return SodaDdl.this.httpLowLevel.putRaw(uri, HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            column2 = (Column)response.readEntity(Column.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), Column.class, (SodaRequest)requester);
            }
        }
        response.close();
        return column2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetResponse addAsset(File file) throws SodaError, InterruptedException, IOException {
        AssetResponse assetResponse;
        SodaRequest<File> requester = new SodaRequest<File>(null, file){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return SodaDdl.this.httpLowLevel.postFileRaw(SodaDdl.this.assetUri, MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_PLAIN_TYPE, (File)this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            assetResponse = (AssetResponse)this.mapper.readValue((InputStream)response.readEntity(InputStream.class), AssetResponse.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), AssetResponse.class, (SodaRequest)requester);
            }
            catch (JsonMappingException e) {
                throw new SodaError("Illegal response from the service.");
            }
            catch (JsonParseException e) {
                throw new SodaError("Invalid JSON returned from the service.");
            }
            catch (IOException e) {
                throw new SodaError("Error communicating with service.", e);
            }
        }
        response.close();
        return assetResponse;
    }

    public InputStream getAsset(String id) throws SodaError, InterruptedException {
        SodaRequest<File> requester = new SodaRequest<File>(id, null){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI uri = UriBuilder.fromUri((URI)SodaDdl.this.assetUri).path(this.resourceId).build(new Object[0]);
                return SodaDdl.this.httpLowLevel.queryRaw(uri, MediaType.WILDCARD_TYPE);
            }
        };
        try {
            Response response = requester.issueRequest();
            return (InputStream)response.readEntity(InputStream.class);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), InputStream.class, (SodaRequest)requester);
        }
    }

    public InputStream getFileBlob(NonDataFileDataset dataset) throws SodaError, InterruptedException {
        Preconditions.checkArgument((dataset.getBlobId() != null ? 1 : 0) != 0, (Object)"Dataset MUST be imported already before calling this.  Otherwise, the file doesn't have a Blob ID yet.");
        SodaRequest<File> requester = new SodaRequest<File>(dataset.getBlobId(), null){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI uri = UriBuilder.fromUri((URI)SodaDdl.this.fileResourceUri).path(this.resourceId).build(new Object[0]);
                return SodaDdl.this.httpLowLevel.queryRaw(uri, MediaType.WILDCARD_TYPE);
            }
        };
        try {
            Response response = requester.issueRequest();
            return (InputStream)response.readEntity(InputStream.class);
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), InputStream.class, (SodaRequest)requester);
        }
    }
}

