/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.socrata.api.ContentEncoding;
import com.socrata.api.HttpLowLevel;
import com.socrata.api.LongRunningRequest;
import com.socrata.api.SodaDdl;
import com.socrata.builders.BlueprintBuilder;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.importer.Blueprint;
import com.socrata.model.importer.BlueprintColumn;
import com.socrata.model.importer.Dataset;
import com.socrata.model.importer.DatasetInfo;
import com.socrata.model.importer.NonDataFileDataset;
import com.socrata.model.importer.ScanResults;
import com.socrata.model.importer.ShapeBlueprint;
import com.socrata.model.importer.ShapeScanResults;
import com.socrata.model.requests.SodaRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;

public class SodaImporter
extends SodaDdl {
    public static final String SCAN_BASE_PATH = "imports2";
    private final URI importUri;

    public static final SodaImporter newImporter(String url, String userName, String password, String token) {
        return new SodaImporter(HttpLowLevel.instantiateBasic(url, userName, password, token, null));
    }

    public SodaImporter(HttpLowLevel httpLowLevel) {
        super(httpLowLevel);
        this.importUri = httpLowLevel.uriBuilder().path("api").path(SCAN_BASE_PATH).build(new Object[0]);
    }

    public DatasetInfo createViewFromCsv(String name, String description, File file, @Nullable String rowIdentifierColumnName) throws InterruptedException, SodaError, IOException {
        return this.importScanResults(name, description, file, this.scan(file), rowIdentifierColumnName);
    }

    public DatasetInfo createViewFromCsv(String name, String description, File file) throws InterruptedException, SodaError, IOException {
        return this.importScanResults(name, description, file, this.scan(file));
    }

    public DatasetInfo createViewFromShapefile(File file) throws SodaError, InterruptedException, IOException {
        ShapeScanResults shapeScanResults = this.scanShapeFile(file);
        return this.importShapeScanResults(ShapeBlueprint.fromScanResults(shapeScanResults), file, shapeScanResults);
    }

    public DatasetInfo replaceViewFromShapefile(String viewId, File file) throws SodaError, InterruptedException, IOException {
        ShapeScanResults shapeScanResults = this.scanShapeFile(file);
        return this.replaceShapeScanResults(viewId, ShapeBlueprint.fromScanResults(shapeScanResults), file, shapeScanResults);
    }

    public ScanResults scan(File file) throws SodaError, InterruptedException {
        return this.scanFile("scan", HttpLowLevel.CSV_TYPE, file, ScanResults.class);
    }

    public ShapeScanResults scanShapeFile(File file) throws SodaError, InterruptedException {
        return this.scanFile("scanShape", MediaType.APPLICATION_OCTET_STREAM_TYPE, file, ShapeScanResults.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T scanFile(final String method, MediaType mediaType, final File file, Class<T> retType) throws SodaError, InterruptedException {
        SodaRequest<File> requester = new SodaRequest<File>(null, file){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI scanUri = UriBuilder.fromUri((URI)SodaImporter.this.importUri).queryParam("method", new Object[]{method}).build(new Object[0]);
                try (FileInputStream is = new FileInputStream((File)this.payload);){
                    Response response = SodaImporter.this.httpLowLevel.postRaw(scanUri, MediaType.APPLICATION_OCTET_STREAM_TYPE, ContentEncoding.IDENTITY, is, file.getName());
                    return response;
                }
                catch (IOException e) {
                    throw new SodaError("Unable to load file: " + file.getAbsolutePath(), e);
                }
            }
        };
        try (Response response = requester.issueRequest();){
            Object object = response.readEntity(retType);
            return (T)object;
        }
        catch (LongRunningQueryException e) {
            return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), retType, (SodaRequest)requester);
        }
    }

    public DatasetInfo importScanResults(String name, String description, File file, ScanResults scanResults) throws SodaError, InterruptedException, IOException {
        return this.importScanResults(name, description, file, scanResults, null, false);
    }

    public DatasetInfo importScanResults(String name, String description, File file, ScanResults scanResults, @Nullable String rowIdentifierColumnName) throws SodaError, InterruptedException, IOException {
        return this.importScanResults(name, description, file, scanResults, rowIdentifierColumnName, false);
    }

    public DatasetInfo importScanResults(String name, String description, File file, ScanResults scanResults, @Nullable String rowIdentifierColumnName, boolean async) throws SodaError, InterruptedException, IOException {
        Blueprint blueprint = new BlueprintBuilder(scanResults).setSkip(1).setName(name).setDescription(description).build();
        DatasetInfo createdDatasetInfo = this.importScanResults(blueprint, null, file, scanResults, async);
        if (rowIdentifierColumnName != null) {
            Dataset createdDataset = (Dataset)this.loadDatasetInfo(createdDatasetInfo.getId());
            try {
                createdDataset.setupRowIdentifierColumnByName(rowIdentifierColumnName);
                createdDatasetInfo = this.updateDatasetInfo(createdDataset);
            }
            catch (IllegalArgumentException e) {
                this.deleteDataset(createdDataset.getId());
                throw e;
            }
        }
        return this.loadDatasetInfo(createdDatasetInfo.getId());
    }

    public DatasetInfo importScanResults(Blueprint blueprint, String[] translation, File file, ScanResults scanResults) throws SodaError, InterruptedException, IOException {
        return this.importScanResults(blueprint, translation, file, scanResults, false);
    }

    public DatasetInfo importScanResults(Blueprint blueprint, String[] translation, File file, ScanResults scanResults, boolean async) throws SodaError, InterruptedException, IOException {
        String blueprintString = this.mapper.writeValueAsString((Object)blueprint);
        String blueprintBody = "blueprint=" + URLEncoder.encode(blueprintString, "UTF-8");
        return this.sendScanResults(blueprintBody, scanResults.getFileId(), translation, file, async);
    }

    public DatasetInfo importShapeScanResults(ShapeBlueprint blueprint, File file, ShapeScanResults scanResults) throws SodaError, InterruptedException, IOException {
        return this.sendShapeScanResults(scanResults.getFileId(), "shapefile", blueprint, file, null);
    }

    public DatasetInfo replaceShapeScanResults(String viewId, ShapeBlueprint blueprint, File file, ShapeScanResults scanResults) throws SodaError, InterruptedException, IOException {
        return this.sendShapeScanResults(scanResults.getFileId(), "replaceShapefile", blueprint, file, viewId);
    }

    public DatasetInfo append(String datasetId, File file, int skip, String[] translation) throws SodaError, InterruptedException, IOException {
        return this.append(datasetId, file, skip, translation, false);
    }

    public DatasetInfo append(String datasetId, File file, int skip, String[] translation, boolean async) throws SodaError, InterruptedException, IOException {
        ScanResults results = this.scan(file);
        return this.updateFromScanResults(datasetId, "append", skip, results.getFileId(), translation, file, async);
    }

    public DatasetInfo replace(String datasetId, File file, int skip, String[] translation) throws SodaError, InterruptedException, IOException {
        return this.replace(datasetId, file, skip, translation, false);
    }

    public DatasetInfo replace(String datasetId, File file, int skip, String[] translation, boolean async) throws SodaError, InterruptedException, IOException {
        ScanResults results = this.scan(file);
        return this.updateFromScanResults(datasetId, "replace", skip, results.getFileId(), translation, file, async);
    }

    protected DatasetInfo updateFromScanResults(String datasetId, String method, int skip, String fileId, String[] translation, File file, boolean async) throws SodaError, InterruptedException, IOException {
        StringBuilder updateBody = new StringBuilder();
        updateBody.append("viewUid=").append(datasetId).append("&method=").append(method).append("&skip=").append(skip);
        return this.sendScanResults(updateBody.toString(), fileId, translation, file, async);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatasetInfo sendScanResults(String basePostBody, String fileId, String[] translation, File file, boolean async) throws SodaError, InterruptedException, IOException {
        DatasetInfo datasetInfo;
        StringBuilder postbodyBuilder = new StringBuilder(basePostBody);
        String translationString = translation != null ? "[" + StringUtils.join((Object[])translation, (String)",") + "]" : "";
        postbodyBuilder.append("&fileId=").append(fileId).append("&translation=").append(URLEncoder.encode(translationString, "UTF-8")).append("&name=").append(URLEncoder.encode(file.getName(), "UTF-8")).append("&async=").append(URLEncoder.encode(Boolean.toString(async), "UTF-8"));
        SodaRequest<String> requester = new SodaRequest<String>(null, postbodyBuilder.toString()){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return SodaImporter.this.httpLowLevel.postRaw(SodaImporter.this.importUri, MediaType.APPLICATION_FORM_URLENCODED_TYPE, ContentEncoding.IDENTITY, this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            datasetInfo = (DatasetInfo)response.readEntity(DatasetInfo.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                LongRunningQueryException lrqe = e.location != null ? e : new LongRunningQueryException(UriBuilder.fromUri((URI)this.importUri).queryParam("ticket", new Object[]{e.ticket}).build(new Object[0]), e.timeToRetry, e.ticket);
                LongRunningRequest<String, DatasetInfo> longRunningRequest = new LongRunningRequest<String, DatasetInfo>(lrqe, DatasetInfo.class, requester);
                HttpLowLevel http = this.getHttpLowLevel();
                return longRunningRequest.checkStatus(http, http.getStatusCheckErrorRetries(), http.getStatusCheckErrorTime());
            }
        }
        response.close();
        return datasetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatasetInfo sendShapeScanResults(String fileId, String method, ShapeBlueprint shapeBlueprint, File file, String viewId) throws SodaError, InterruptedException, IOException {
        DatasetInfo datasetInfo;
        StringBuilder postbodyBuilder = new StringBuilder();
        String blueprintString = this.mapper.writeValueAsString((Object)shapeBlueprint);
        final URI shapeImportUri = UriBuilder.fromUri((URI)this.importUri).queryParam("method", new Object[]{method}).build(new Object[0]);
        postbodyBuilder.append("&fileId=").append(fileId).append("&name=").append(URLEncoder.encode(file.getName(), "UTF-8")).append("&blueprint=").append(URLEncoder.encode(blueprintString, "UTF-8"));
        if (StringUtils.isNotEmpty((CharSequence)viewId)) {
            postbodyBuilder.append("&viewUid=").append(viewId);
        }
        SodaRequest<String> requester = new SodaRequest<String>(null, postbodyBuilder.toString()){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                return SodaImporter.this.httpLowLevel.postRaw(shapeImportUri, MediaType.APPLICATION_FORM_URLENCODED_TYPE, ContentEncoding.IDENTITY, this.payload);
            }
        };
        Response response = requester.issueRequest();
        try {
            datasetInfo = (DatasetInfo)response.readEntity(DatasetInfo.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                if (e.location != null) {
                    return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, Integer.MAX_VALUE, DatasetInfo.class, (SodaRequest)requester);
                }
                URI ticketUri = UriBuilder.fromUri((URI)shapeImportUri).queryParam("ticket", new Object[]{e.ticket}).build(new Object[0]);
                return this.getHttpLowLevel().getAsyncResults(ticketUri, e.timeToRetry, Integer.MAX_VALUE, DatasetInfo.class, (SodaRequest)requester);
            }
        }
        response.close();
        return datasetInfo;
    }

    public NonDataFileDataset importNonDataFile(String name, String description, final File file) throws SodaError, InterruptedException {
        NonDataFileDataset nonDataFileDataset;
        SodaRequest<File> requester = new SodaRequest<File>(null, file){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI scanUri = UriBuilder.fromUri((URI)SodaImporter.this.importUri).queryParam("method", new Object[]{"blob"}).queryParam("fileUploaderfile", new Object[]{file.getName()}).build(new Object[0]);
                try (FileInputStream is = new FileInputStream(file);){
                    Response response = SodaImporter.this.httpLowLevel.postRaw(scanUri, MediaType.APPLICATION_OCTET_STREAM_TYPE, MediaType.TEXT_PLAIN_TYPE, ContentEncoding.IDENTITY, is, file.getName());
                    return response;
                }
                catch (IOException ioe) {
                    throw new SodaError("Unable to load file: " + file.getAbsolutePath(), ioe);
                }
            }
        };
        try (Response response = requester.issueRequest();){
            nonDataFileDataset = (NonDataFileDataset)this.mapper.readValue((String)response.readEntity(String.class), NonDataFileDataset.class);
        }
        catch (LongRunningQueryException e) {
            nonDataFileDataset = this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), NonDataFileDataset.class, (SodaRequest)requester);
        }
        nonDataFileDataset.setDescription(description);
        nonDataFileDataset.setName(name);
        return (NonDataFileDataset)this.updateDatasetInfo(nonDataFileDataset);
    }

    public NonDataFileDataset replaceNonDataFile(final String id, final File file) throws SodaError, InterruptedException {
        SodaRequest<File> requester = new SodaRequest<File>(null, file){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI scanUri = UriBuilder.fromUri((URI)SodaImporter.this.viewUri).path(id + ".txt").queryParam("method", new Object[]{"replaceBlob"}).queryParam("fileUploaderfile", new Object[]{file.getName()}).build(new Object[0]);
                try (FileInputStream is = new FileInputStream(file);){
                    Response response = SodaImporter.this.httpLowLevel.postRaw(scanUri, MediaType.APPLICATION_OCTET_STREAM_TYPE, MediaType.TEXT_PLAIN_TYPE, ContentEncoding.IDENTITY, is, file.getName());
                    return response;
                }
                catch (IOException ioe) {
                    throw new SodaError("Unable to load file: " + file.getAbsolutePath(), ioe);
                }
            }
        };
        try (Response response = requester.issueRequest();){
            NonDataFileDataset nonDataFileDataset = (NonDataFileDataset)this.mapper.readValue((String)response.readEntity(String.class), NonDataFileDataset.class);
        }
        catch (LongRunningQueryException e) {
            NonDataFileDataset nonDataFileDataset = this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), NonDataFileDataset.class, (SodaRequest)requester);
        }
        return (NonDataFileDataset)this.loadDatasetInfo(id);
    }

    public String[] generateTranslation(Blueprint blueprint) {
        String[] retVal = new String[blueprint.getColumns().size()];
        int i = 0;
        for (BlueprintColumn column : blueprint.getColumns()) {
            retVal[i] = "col" + i;
            ++i;
        }
        return retVal;
    }
}

