/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.socrata.api.ContentEncoding;
import com.socrata.api.HttpLowLevel;
import com.socrata.api.LongRunningRequest;
import com.socrata.exceptions.LongRunningQueryException;
import com.socrata.exceptions.SodaError;
import com.socrata.model.Comment;
import com.socrata.model.GeocodingResults;
import com.socrata.model.importer.Dataset;
import com.socrata.model.importer.DatasetInfo;
import com.socrata.model.requests.SodaRequest;
import java.net.URI;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

public class SodaWorkflow {
    protected static final String API_BASE_PATH = "api";
    protected static final String GEO_BASE_PATH = "geocoding";
    protected static final long TICKET_CHECK = 10000L;
    protected static final String VIEWS_BASE_PATH = "views";
    protected static final String COMMENTS_METHOD_PATH = "comments";
    protected final URI geocodingUri;
    protected final HttpLowLevel httpLowLevel;
    protected final URI viewUri;
    protected final ObjectMapper mapper;

    public static final SodaWorkflow newWorkflow(String url, String userName, String password, String token) {
        return new SodaWorkflow(HttpLowLevel.instantiateBasic(url, userName, password, token, null));
    }

    public SodaWorkflow(HttpLowLevel httpLowLevel) {
        this.httpLowLevel = httpLowLevel;
        this.geocodingUri = httpLowLevel.uriBuilder().path(API_BASE_PATH).path(GEO_BASE_PATH).build(new Object[0]);
        this.viewUri = httpLowLevel.uriBuilder().path(API_BASE_PATH).path(VIEWS_BASE_PATH).build(new Object[0]);
        this.mapper = httpLowLevel.getObjectMapper();
    }

    public HttpLowLevel getHttpLowLevel() {
        return this.httpLowLevel;
    }

    public DatasetInfo publish(String datasetId) throws SodaError, InterruptedException {
        return this.publish(datasetId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetInfo publish(String datasetId, final boolean async) throws SodaError, InterruptedException {
        DatasetInfo datasetInfo;
        this.waitForPendingGeocoding(datasetId);
        SodaRequest<String> requester = new SodaRequest<String>(datasetId, null){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI publicationUri = UriBuilder.fromUri((URI)SodaWorkflow.this.viewUri).path(this.resourceId).path("publication").build(new Object[0]);
                String querystring = "viewId=" + this.resourceId + "&async=" + Boolean.toString(async);
                return SodaWorkflow.this.httpLowLevel.postRaw(publicationUri, HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, querystring);
            }
        };
        Response response = requester.issueRequest();
        try {
            datasetInfo = (DatasetInfo)response.readEntity(DatasetInfo.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                LongRunningRequest<String, DatasetInfo> longRunningRequest = new LongRunningRequest<String, DatasetInfo>(e, DatasetInfo.class, requester);
                HttpLowLevel http = this.getHttpLowLevel();
                return longRunningRequest.checkStatus(http, http.getStatusCheckErrorRetries(), http.getStatusCheckErrorTime());
            }
        }
        response.close();
        return datasetInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetInfo createWorkingCopy(String datasetId) throws SodaError, InterruptedException {
        DatasetInfo datasetInfo;
        SodaRequest<String> requester = new SodaRequest<String>(datasetId, null){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI publicationUri = UriBuilder.fromUri((URI)SodaWorkflow.this.viewUri).path(this.resourceId).path("publication.json").queryParam("method", new Object[]{"copy"}).build(new Object[0]);
                return SodaWorkflow.this.httpLowLevel.postRaw(publicationUri, HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, "method=copy");
            }
        };
        Response response = requester.issueRequest();
        try {
            datasetInfo = (DatasetInfo)response.readEntity(Dataset.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                LongRunningRequest<String, DatasetInfo> longRunningRequest = new LongRunningRequest<String, DatasetInfo>(e, DatasetInfo.class, requester);
                HttpLowLevel http = this.getHttpLowLevel();
                return longRunningRequest.checkStatus(http, http.getStatusCheckErrorRetries(), http.getStatusCheckErrorTime());
            }
        }
        response.close();
        return datasetInfo;
    }

    public void makePublic(String datasetId) throws SodaError, InterruptedException {
        SodaRequest<String> requester = new SodaRequest<String>(datasetId, null){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI publicationUri = UriBuilder.fromUri((URI)SodaWorkflow.this.viewUri).path(this.resourceId).queryParam("accessType", new Object[]{"WEBSITE"}).queryParam("method", new Object[]{"setPermission"}).queryParam("value", new Object[]{"public.read"}).build(new Object[0]);
                return SodaWorkflow.this.httpLowLevel.putRaw(publicationUri, HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, "method=setPermission");
            }
        };
        try {
            requester.issueRequest().close();
        }
        catch (LongRunningQueryException e) {
            this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), Dataset.class, (SodaRequest)requester);
        }
    }

    public void makePrivate(String datasetId) throws SodaError, InterruptedException {
        SodaRequest<String> requester = new SodaRequest<String>(datasetId, null){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI publicationUri = UriBuilder.fromUri((URI)SodaWorkflow.this.viewUri).path(this.resourceId).queryParam("accessType", new Object[]{"WEBSITE"}).queryParam("method", new Object[]{"setPermission"}).queryParam("value", new Object[]{"private"}).build(new Object[0]);
                return SodaWorkflow.this.httpLowLevel.putRaw(publicationUri, HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, "method=setPermission");
            }
        };
        try {
            requester.issueRequest().close();
        }
        catch (LongRunningQueryException e) {
            this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), Dataset.class, (SodaRequest)requester);
        }
    }

    public void waitForPendingGeocoding(String datasetId) throws InterruptedException, SodaError {
        GeocodingResults geocodingResults = this.findPendingGeocodingResults(datasetId);
        while (geocodingResults.getView() > 0L) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            geocodingResults = this.findPendingGeocodingResults(datasetId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeocodingResults findPendingGeocodingResults(final String datasetId) throws SodaError, InterruptedException {
        GeocodingResults geocodingResults;
        SodaRequest<String> requester = new SodaRequest<String>(datasetId, null){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI uri = UriBuilder.fromUri((URI)SodaWorkflow.this.geocodingUri).path(datasetId).queryParam("method", new Object[]{"pending"}).build(new Object[0]);
                return SodaWorkflow.this.httpLowLevel.queryRaw(uri, HttpLowLevel.JSON_TYPE);
            }
        };
        Response response = requester.issueRequest();
        try {
            geocodingResults = (GeocodingResults)response.readEntity(GeocodingResults.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), GeocodingResults.class, (SodaRequest)requester);
            }
        }
        response.close();
        return geocodingResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comment addComment(final String datasetId, final Comment comment) throws SodaError, InterruptedException {
        Comment comment2;
        SodaRequest<String> requester = new SodaRequest<String>(datasetId, null){

            @Override
            public Response issueRequest() throws LongRunningQueryException, SodaError {
                URI uri = UriBuilder.fromUri((URI)SodaWorkflow.this.viewUri).path(datasetId).path(SodaWorkflow.COMMENTS_METHOD_PATH).build(new Object[0]);
                return SodaWorkflow.this.httpLowLevel.postRaw(uri, HttpLowLevel.JSON_TYPE, ContentEncoding.IDENTITY, comment);
            }
        };
        Response response = requester.issueRequest();
        try {
            comment2 = (Comment)response.readEntity(Comment.class);
        }
        catch (Throwable throwable) {
            try {
                response.close();
                throw throwable;
            }
            catch (LongRunningQueryException e) {
                return this.getHttpLowLevel().getAsyncResults(e.location, e.timeToRetry, this.getHttpLowLevel().getMaxRetries(), Comment.class, (SodaRequest)requester);
            }
        }
        response.close();
        return comment2;
    }
}

