/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.builders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.socrata.model.importer.Column;
import com.socrata.model.importer.DatasetInfo;
import com.socrata.model.importer.License;
import com.socrata.model.importer.Metadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractDatasetInfoBuilder<BUILDER extends AbstractDatasetInfoBuilder, BUILDEE extends DatasetInfo> {
    protected String resourceName;
    protected String viewType;
    protected String displayType;
    protected String attribution;
    protected String attributionLink;
    protected String category;
    protected String description;
    protected String externalId;
    protected String id;
    protected License license;
    protected String licenseId;
    protected String name;
    protected Metadata metadata;
    protected Map<String, Object> privateMetadata;
    protected String publicationStage;
    protected List<String> tags = new ArrayList<String>();
    protected List<Column> columns = new ArrayList<Column>();

    public AbstractDatasetInfoBuilder() {
    }

    public AbstractDatasetInfoBuilder(DatasetInfo datasetInfo) {
        this.setResourceName(datasetInfo.getResourceName());
        this.setAttribution(datasetInfo.getAttribution());
        this.setAttributionLink(datasetInfo.getAttributionLink());
        this.setCategory(datasetInfo.getCategory());
        this.setDescription(datasetInfo.getDescription());
        this.setExternalId(datasetInfo.getExternalId());
        this.setId(datasetInfo.getId());
        this.setLicense(datasetInfo.getLicense());
        this.setLicenseId(datasetInfo.getLicenseId());
        this.setName(datasetInfo.getName());
        this.setPublicationStage(datasetInfo.getPublicationStage());
        if (datasetInfo.getMetadata() != null) {
            this.setMetadata(Metadata.copy(datasetInfo.getMetadata()));
        }
        if (datasetInfo.getTags() != null) {
            this.setTags(Lists.newArrayList(datasetInfo.getTags()));
        }
        if (datasetInfo.getPrivateMetadata() != null) {
            this.setPrivateMetadata(Maps.newHashMap(datasetInfo.getPrivateMetadata()));
        }
    }

    public BUILDER setResourceName(String resourceName) {
        this.resourceName = resourceName;
        return (BUILDER)this;
    }

    public BUILDER setViewType(String viewType) {
        this.viewType = viewType;
        return (BUILDER)this;
    }

    public BUILDER setDisplayType(String displayType) {
        this.displayType = displayType;
        return (BUILDER)this;
    }

    public BUILDER setAttribution(String attribution) {
        this.attribution = attribution;
        return (BUILDER)this;
    }

    public BUILDER setAttributionLink(String attributionLink) {
        this.attributionLink = attributionLink;
        return (BUILDER)this;
    }

    public BUILDER setCategory(String category) {
        this.category = category;
        return (BUILDER)this;
    }

    public BUILDER setDescription(String description) {
        this.description = description;
        return (BUILDER)this;
    }

    public BUILDER setExternalId(String externalId) {
        this.externalId = externalId;
        return (BUILDER)this;
    }

    public BUILDER setId(String id) {
        this.id = id;
        return (BUILDER)this;
    }

    public BUILDER setLicense(License license) {
        this.license = license;
        return (BUILDER)this;
    }

    public BUILDER setLicenseId(String licenseId) {
        this.licenseId = licenseId;
        return (BUILDER)this;
    }

    public BUILDER setName(String name) {
        this.name = name;
        return (BUILDER)this;
    }

    public BUILDER setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return (BUILDER)this;
    }

    public BUILDER setPrivateMetadata(Map<String, Object> privateMetadata) {
        this.privateMetadata = privateMetadata;
        return (BUILDER)this;
    }

    public BUILDER setPublicationStage(String publicationStage) {
        this.publicationStage = publicationStage;
        return (BUILDER)this;
    }

    public BUILDER setTags(List<String> tags) {
        this.tags = tags;
        return (BUILDER)this;
    }

    public BUILDER addTag(String tag) {
        if (this.tags == null) {
            this.tags = Lists.newArrayList();
        }
        this.tags.add(tag);
        return (BUILDER)this;
    }

    public BUILDER removeTag(String tag) {
        if (this.tags != null) {
            this.tags.remove(tag);
        }
        return (BUILDER)this;
    }

    public void populate(DatasetInfo retVal) {
        retVal.setResourceName(this.resourceName);
        retVal.setAttribution(this.attribution);
        retVal.setAttributionLink(this.attributionLink);
        retVal.setCategory(this.category);
        retVal.setDescription(this.description);
        retVal.setDisplayType(this.displayType);
        retVal.setExternalId(this.externalId);
        retVal.setId(this.id);
        retVal.setLicense(this.license);
        retVal.setLicenseId(this.licenseId);
        retVal.setName(this.name);
        retVal.setMetadata(this.metadata);
        retVal.setPrivateMetadata(this.privateMetadata);
        retVal.setPublicationStage(this.publicationStage);
        retVal.setTags(this.tags);
    }

    public abstract BUILDEE build();
}

