/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.builders;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.socrata.model.importer.Blueprint;
import com.socrata.model.importer.BlueprintColumn;
import com.socrata.model.importer.ScanColumn;
import com.socrata.model.importer.ScanResults;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class BlueprintBuilder {
    public static final Function<ScanColumn, BlueprintColumn> CONVERT_BLUPRINT = new Function<ScanColumn, BlueprintColumn>(){

        public BlueprintColumn apply(@Nullable ScanColumn input) {
            return new BlueprintColumn(input.getName(), "", input.getSuggestion());
        }
    };
    String name;
    String description;
    int skip;
    List<BlueprintColumn> columns;

    public BlueprintBuilder() {
        this.columns = new ArrayList<BlueprintColumn>();
    }

    public BlueprintBuilder(ScanResults scanResults) {
        this.skip = scanResults.getSummary().getHeaders();
        this.columns = Lists.newArrayList((Iterable)Collections2.transform(scanResults.getSummary().getColumns(), CONVERT_BLUPRINT));
    }

    public BlueprintBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public BlueprintBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public BlueprintBuilder setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public BlueprintBuilder addColumn(BlueprintColumn column) {
        this.columns.add(column);
        return this;
    }

    public Blueprint build() {
        return new Blueprint(this.name, this.description, this.skip, this.columns);
    }
}

