/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.builders;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.socrata.builders.AbstractDatasetInfoBuilder;
import com.socrata.model.importer.Column;
import com.socrata.model.importer.Dataset;
import com.socrata.model.importer.DatasetInfo;
import java.util.ArrayList;
import java.util.List;

public class DatasetBuilder
extends AbstractDatasetInfoBuilder<DatasetBuilder, Dataset> {
    private final List<Column> columns = new ArrayList<Column>();

    public DatasetBuilder() {
    }

    public DatasetBuilder(DatasetInfo datasetInfo) {
        super(datasetInfo);
        if (datasetInfo instanceof Dataset) {
            List<Column> columns = ((Dataset)datasetInfo).getColumns();
            ArrayList translatedColumns = Lists.newArrayList((Iterable)Collections2.transform(columns, Column.COPY));
            this.setColumns(translatedColumns);
        }
    }

    public DatasetBuilder setColumns(List<Column> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
        return this;
    }

    public DatasetBuilder addColumn(Column column) {
        this.columns.add(column);
        return this;
    }

    public DatasetBuilder removeColumn(String columnName) {
        for (Column column : this.columns) {
            if (!columnName.equals(column.getName())) continue;
            this.columns.remove(column);
            break;
        }
        return this;
    }

    public DatasetBuilder updateColumn(String columnName, Column columnToUpdateTo) {
        int i = 0;
        for (Column column : this.columns) {
            if (columnName.equals(column.getName())) {
                this.columns.set(i, columnToUpdateTo);
                break;
            }
            ++i;
        }
        return this;
    }

    @Override
    public Dataset build() {
        Dataset retVal = new Dataset();
        this.populate(retVal);
        retVal.setColumns(new ArrayList<Column>(this.columns));
        return retVal;
    }
}

