/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.builders;

import com.google.common.collect.Lists;
import com.socrata.model.soql.ConditionalExpression;
import com.socrata.model.soql.Expression;
import com.socrata.model.soql.OrderByClause;
import com.socrata.model.soql.SoqlQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SoqlQueryBuilder {
    private final List<String> selectClause;
    private final List<String> groupByClause;
    private final List<OrderByClause> orderByClause;
    private Expression havingClause;
    private Expression whereClause;
    private String fullTextSearchClause;
    private Integer offset;
    private Integer limit;

    public SoqlQueryBuilder() {
        this.selectClause = Lists.newArrayList();
        this.groupByClause = Lists.newArrayList();
        this.orderByClause = Lists.newArrayList();
    }

    public SoqlQueryBuilder(SoqlQuery soqlQuery) {
        this.selectClause = soqlQuery.selectClause != null ? Lists.newArrayList(soqlQuery.selectClause) : new ArrayList<String>();
        this.groupByClause = soqlQuery.groupByClause != null ? Lists.newArrayList(soqlQuery.groupByClause) : new ArrayList<String>();
        this.orderByClause = soqlQuery.orderByClause != null ? Lists.newArrayList(soqlQuery.orderByClause) : new ArrayList<OrderByClause>();
        this.havingClause = soqlQuery.havingClause;
        this.whereClause = soqlQuery.whereClause;
        this.fullTextSearchClause = soqlQuery.fullTextSearchClause;
        this.offset = soqlQuery.offset;
        this.limit = soqlQuery.limit;
    }

    @Nonnull
    public SoqlQueryBuilder setSelectPhrase(@Nonnull List<String> phrases) {
        return this.setList(this.selectClause, phrases);
    }

    @Nonnull
    public SoqlQueryBuilder addSelectPhrase(@Nonnull String newValue) {
        return this.addToList(this.selectClause, newValue);
    }

    @Nonnull
    public SoqlQueryBuilder addSelectPhrases(@Nonnull Collection<String> newValues) {
        return this.addAllToList(this.selectClause, newValues);
    }

    @Nonnull
    public SoqlQueryBuilder setGroupByPhrase(@Nonnull List<String> phrases) {
        return this.setList(this.groupByClause, phrases);
    }

    @Nonnull
    public SoqlQueryBuilder addGroupByPhrase(@Nonnull String newValue) {
        return this.addToList(this.groupByClause, newValue);
    }

    @Nonnull
    public SoqlQueryBuilder addGroupByPhrases(@Nonnull Collection<String> newValues) {
        return this.addAllToList(this.groupByClause, newValues);
    }

    @Nonnull
    public SoqlQueryBuilder setOrderByPhrase(@Nonnull List<OrderByClause> phrases) {
        return this.setList(this.orderByClause, phrases);
    }

    @Nonnull
    public SoqlQueryBuilder addOrderByPhrase(@Nonnull OrderByClause newValue) {
        return this.addToList(this.orderByClause, newValue);
    }

    @Nonnull
    public SoqlQueryBuilder addOrderByPhrases(@Nonnull Collection<OrderByClause> newValues) {
        return this.addAllToList(this.orderByClause, newValues);
    }

    @Nonnull
    public SoqlQueryBuilder setHavingClause(@Nullable Expression havingClause) {
        this.havingClause = havingClause;
        return this;
    }

    @Nonnull
    public SoqlQueryBuilder setWhereClause(@Nullable Expression whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    @Nonnull
    public SoqlQueryBuilder setWhereClause(@Nullable String whereClause) {
        this.whereClause = new ConditionalExpression(whereClause);
        return this;
    }

    @Nonnull
    public SoqlQueryBuilder setFullTextSearchClause(@Nullable String fullTextSearchClause) {
        this.fullTextSearchClause = fullTextSearchClause;
        return this;
    }

    @Nonnull
    public SoqlQueryBuilder setOffset(@Nullable Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nonnull
    public SoqlQueryBuilder setLimit(@Nullable Integer limit) {
        this.limit = limit;
        return this;
    }

    public SoqlQuery build() {
        return new SoqlQuery(this.selectClause.isEmpty() ? null : this.selectClause, this.whereClause, this.groupByClause.isEmpty() ? null : this.groupByClause, this.havingClause, this.orderByClause.isEmpty() ? null : this.orderByClause, this.fullTextSearchClause, this.offset, this.limit);
    }

    private final <E> SoqlQueryBuilder setList(List<E> existingList, Collection<E> newValues) {
        existingList.clear();
        existingList.addAll(newValues);
        return this;
    }

    private final <E> SoqlQueryBuilder addToList(List<E> existingList, E newValue) {
        existingList.add(newValue);
        return this;
    }

    private final <E> SoqlQueryBuilder addAllToList(List<E> existingList, Collection<E> newValues) {
        existingList.addAll(newValues);
        return this;
    }
}

