/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.socrata.model.UpsertError;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UpsertResult {
    public final long rowsCreated;
    public final long rowsUpdated;
    public final long rowsDeleted;
    public final List<UpsertError> errors;
    public final Long truthDataVersion;

    @JsonCreator
    public UpsertResult(@JsonProperty(value="rows_created") long rowsCreated, @JsonProperty(value="rows_updated") long rowsUpdated, @JsonProperty(value="rows_deleted") long rowsDeleted, @JsonProperty(value="errors") List<UpsertError> errors, @JsonProperty(value="truth_data_version") Long truthDataVersion) {
        this.rowsCreated = rowsCreated;
        this.rowsUpdated = rowsUpdated;
        this.rowsDeleted = rowsDeleted;
        this.truthDataVersion = truthDataVersion;
        this.errors = errors;
    }

    public UpsertResult(long rowsCreated, long rowsUpdated, long rowsDeleted, List<UpsertError> errors) {
        this(rowsCreated, rowsUpdated, rowsDeleted, errors, null);
    }

    public long getRowsCreated() {
        return this.rowsCreated;
    }

    public long getRowsUpdated() {
        return this.rowsUpdated;
    }

    public long getRowsDeleted() {
        return this.rowsDeleted;
    }

    public List<UpsertError> getErrors() {
        return this.errors;
    }

    public long errorCount() {
        return this.errors != null ? (long)this.errors.size() : 0L;
    }

    public Long getTruthDataVersion() {
        return this.truthDataVersion;
    }
}

