/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.model.importer;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Collections2;
import com.socrata.model.importer.Column;
import com.socrata.model.importer.DatasetInfo;
import com.socrata.model.importer.Metadata;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Dataset
extends DatasetInfo {
    public static final GenericType<List<Dataset>> LIST_TYPE = new GenericType<List<Dataset>>(){};
    private Integer rowIdentifierColumnId;
    private final List<String> flags = new ArrayList<String>();
    private final List<Column> columns = new ArrayList<Column>();
    private boolean isNewBackend;

    public Dataset() {
        this.setViewType("tabular");
    }

    public List<Column> getColumns() {
        return new ArrayList<Column>(this.columns);
    }

    public void setColumns(List<Column> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
    }

    public List<String> getFlags() {
        return new ArrayList<String>(this.flags);
    }

    public void setFlags(List<String> flags) {
        this.flags.clear();
        this.flags.addAll(flags);
    }

    public void setupRowIdentifierColumnByName(String columnName) {
        if (columnName != null) {
            for (Column column : this.columns) {
                if (!columnName.equals(column.getName())) continue;
                this.setupRowIdentifierColumn(column);
                return;
            }
            String columnNames = StringUtils.join((Iterable)Collections2.transform(this.columns, Column.TO_NAME), (String)",");
            throw new IllegalArgumentException("No column named " + columnName + " exists for this dataset.  Current column names are: " + columnNames);
        }
        this.setupRowIdentifierColumn(null);
    }

    public void setupRowIdentifierColumn(Column column) {
        if (column != null) {
            if (column.getId() == null) {
                throw new IllegalArgumentException("A column MUST have it's ID set in order to make it a row identifier, this ID will be set on the server when the column is created on a dataset.");
            }
            Metadata metadata = this.getMetadata();
            if (metadata == null) {
                metadata = new Metadata();
                this.setMetadata(metadata);
            }
            metadata.setRowIdentifier(column.getFieldName());
            this.rowIdentifierColumnId = column.getId();
        } else {
            this.rowIdentifierColumnId = null;
            Metadata metadata = this.getMetadata();
            if (metadata != null) {
                metadata.setRowIdentifier(null);
            }
        }
    }

    public Integer getRowIdentifierColumnId() {
        return this.rowIdentifierColumnId;
    }

    public Column lookupRowIdentifierColumn() {
        if (this.getRowIdentifierColumnId() != null) {
            for (Column curr : this.columns) {
                if (!this.getRowIdentifierColumnId().equals(curr.getId())) continue;
                return curr;
            }
        }
        return null;
    }

    public void setRowIdentifierColumnId(Integer rowIdentifierColumnId) {
        this.rowIdentifierColumnId = rowIdentifierColumnId;
    }

    public boolean isNewBackend() {
        return this.isNewBackend;
    }

    public void setNewBackend(boolean isNewBackend) {
        this.isNewBackend = isNewBackend;
    }
}

