/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.model.importer;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.socrata.model.importer.Dataset;
import com.socrata.model.importer.ExternalDataset;
import com.socrata.model.importer.GeoDataset;
import com.socrata.model.importer.Grant;
import com.socrata.model.importer.License;
import com.socrata.model.importer.LicenseInfo;
import com.socrata.model.importer.Metadata;
import com.socrata.model.importer.NonDataFileDataset;
import com.socrata.model.importer.UserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="viewType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Dataset.class, name="tabular"), @JsonSubTypes.Type(value=NonDataFileDataset.class, name="blobby"), @JsonSubTypes.Type(value=ExternalDataset.class, name="href"), @JsonSubTypes.Type(value=GeoDataset.class, name="geo")})
public class DatasetInfo {
    public static final String DATASET_TYPE = "tabular";
    public static final String EXTERNAL_TYPE = "href";
    public static final String FILE_TYPE = "blobby";
    public static final String GEODATASET_TYPE = "geo";
    public static final String PUBLISHED = "published";
    public static final String UNPUBLISHED = "unpublished";
    private String resourceName;
    private String viewType;
    private String displayType;
    private String attribution;
    private String attributionLink;
    private String category;
    private String description;
    private String externalId;
    private String id;
    private License license;
    private String licenseId;
    private String name;
    private Metadata metadata;
    private Map<String, Object> privateMetadata;
    private String publicationStage;
    private Long rowsUpdatedAt;
    private Long viewLastModified;
    private Long createdAt;
    private List<String> rights = new ArrayList<String>();
    private List<String> tags = new ArrayList<String>();
    private List<Grant> grants;
    private UserInfo owner;
    private UserInfo tableAuthor;

    public static DatasetInfo copy(DatasetInfo src) {
        DatasetInfo retVal = new DatasetInfo();
        try {
            BeanUtils.copyProperties((Object)retVal, (Object)src);
            if (retVal.metadata != null) {
                retVal.metadata = Metadata.copy(retVal.getMetadata());
            }
            if (retVal.rights != null) {
                retVal.rights = Lists.newArrayList(retVal.rights);
            }
            if (retVal.tags != null) {
                retVal.tags = Lists.newArrayList(retVal.tags);
            }
            if (retVal.privateMetadata != null) {
                retVal.privateMetadata = Maps.newHashMap(retVal.privateMetadata);
            }
            if (retVal.grants != null) {
                retVal.grants = Lists.newArrayList(retVal.grants);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return retVal;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public String getAttributionLink() {
        return this.attributionLink;
    }

    public void setAttributionLink(String attributionLink) {
        this.attributionLink = attributionLink;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setupLicense(LicenseInfo licenseInfo, String attribution, String attributionLink) {
        if (licenseInfo != null) {
            if (licenseInfo.attributionRequired && attribution == null && attributionLink == null) {
                throw new IllegalArgumentException(licenseInfo.name() + " requires attribution, but no attribution is passed in.");
            }
            this.setLicense(new License(licenseInfo.friendlyName, licenseInfo.logoPath, licenseInfo.termsLink));
            this.setLicenseId(licenseInfo.uniqueId);
            this.setAttribution(attribution);
            this.setAttributionLink(attributionLink);
        } else {
            this.setLicense(null);
            this.setLicenseId(null);
            this.setAttribution(null);
            this.setAttributionLink(null);
        }
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getPrivateMetadata() {
        return this.privateMetadata;
    }

    public void setPrivateMetadata(Map<String, Object> privateMetadata) {
        this.privateMetadata = privateMetadata;
    }

    public String getPublicationStage() {
        return this.publicationStage;
    }

    public void setPublicationStage(String publicationStage) {
        this.publicationStage = publicationStage;
    }

    public List<String> getRights() {
        return this.rights;
    }

    public void setRights(List<String> rights) {
        this.rights = rights;
    }

    public Long getRowsUpdatedAt() {
        return this.rowsUpdatedAt;
    }

    public void setRowsUpdatedAt(Long rowsUpdatedAt) {
        this.rowsUpdatedAt = rowsUpdatedAt;
    }

    public Long getViewLastModified() {
        return this.viewLastModified;
    }

    public void setViewLastModified(Long viewLastModified) {
        this.viewLastModified = viewLastModified;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<Grant> getGrants() {
        return this.grants;
    }

    public void setGrants(List<Grant> grants) {
        this.grants = grants;
    }

    public UserInfo getOwner() {
        return this.owner;
    }

    public void setOwner(UserInfo owner) {
        this.owner = owner;
    }

    public UserInfo getTableAuthor() {
        return this.tableAuthor;
    }

    public void setTableAuthor(UserInfo tableAuthor) {
        this.tableAuthor = tableAuthor;
    }
}

