/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.model.importer;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.socrata.model.importer.Attachment;
import com.socrata.model.importer.GeoInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.BeanUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Metadata {
    Map<String, Map<String, String>> custom_fields;
    List<String> warnings;
    String rowIdentifier;
    String rowLabel;
    String rdfSubject;
    String rdfClass;
    List<Attachment> attachments;
    Map<String, String> accessPoints;
    GeoInfo geo;

    public static Metadata copy(Metadata src) {
        Metadata retVal = new Metadata();
        try {
            BeanUtils.copyProperties((Object)retVal, (Object)src);
            retVal.custom_fields = retVal.custom_fields != null ? Maps.newHashMap((Map)Maps.transformValues(retVal.custom_fields, (Function)new Function<Map<String, String>, Map<String, String>>(){

                public Map<String, String> apply(@Nullable Map<String, String> input) {
                    return Maps.newHashMap(input);
                }
            })) : new HashMap<String, Map<String, String>>();
            retVal.attachments = retVal.attachments != null ? Lists.newArrayList(retVal.attachments) : new ArrayList<Attachment>();
            if (retVal.accessPoints != null) {
                retVal.accessPoints = Maps.newHashMap(retVal.accessPoints);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return retVal;
    }

    public Metadata() {
    }

    public Metadata(Map<String, Map<String, String>> custom_metadata, String rowIdentifier, String rowLabel, String rdfSubject, String rdfClass, List<Attachment> attachments) {
        this.custom_fields = custom_metadata;
        this.rowIdentifier = rowIdentifier;
        this.rowLabel = rowLabel;
        this.rdfSubject = rdfSubject;
        this.rdfClass = rdfClass;
        this.attachments = attachments;
    }

    public Map<String, Map<String, String>> getCustom_fields() {
        return this.custom_fields;
    }

    public void addCustomField(String category, String key, String value) {
        Map<String, String> fields;
        if (this.custom_fields == null) {
            this.custom_fields = Maps.newHashMap();
        }
        if ((fields = this.custom_fields.get(category)) == null) {
            fields = new HashMap<String, String>();
            this.custom_fields.put(category, fields);
        }
        fields.put(key, value);
    }

    public void setCustom_fields(Map<String, Map<String, String>> custom_metadata) {
        this.custom_fields = custom_metadata;
    }

    public String getRowIdentifier() {
        return this.rowIdentifier;
    }

    public void setRowIdentifier(String rowIdentifier) {
        this.rowIdentifier = rowIdentifier;
    }

    public String getRowLabel() {
        return this.rowLabel;
    }

    public void setRowLabel(String rowLabel) {
        this.rowLabel = rowLabel;
    }

    public String getRdfSubject() {
        return this.rdfSubject;
    }

    public void setRdfSubject(String rdfSubject) {
        this.rdfSubject = rdfSubject;
    }

    public String getRdfClass() {
        return this.rdfClass;
    }

    public void setRdfClass(String rdfClass) {
        this.rdfClass = rdfClass;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Map<String, String> getAccessPoints() {
        return this.accessPoints;
    }

    public void setAccessPoints(Map<String, String> accessPoints) {
        this.accessPoints = accessPoints;
    }

    public GeoInfo getGeo() {
        return this.geo;
    }

    public void setGeo(GeoInfo geo) {
        this.geo = geo;
    }
}

