/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.model.importer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.socrata.model.importer.ShapeLayer;
import com.socrata.model.importer.ShapeLayerSummary;
import com.socrata.model.importer.ShapeScanResults;
import com.socrata.model.importer.ShapeScanSummary;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ShapeBlueprint {
    public final List<ShapeLayer> layers;

    public static ShapeBlueprint fromScanResults(ShapeScanResults scanResults) {
        ImmutableList.Builder layers = ImmutableList.builder();
        ShapeScanSummary summary = scanResults != null ? scanResults.getSummary() : null;
        List<ShapeLayerSummary> layerSummaries = summary != null ? summary.getLayers() : Collections.EMPTY_LIST;
        for (ShapeLayerSummary layerSummary : layerSummaries) {
            layers.add((Object)new ShapeLayer(layerSummary.getLayerId(), layerSummary.getName()));
        }
        return new ShapeBlueprint((List<ShapeLayer>)layers.build());
    }

    @JsonCreator
    public ShapeBlueprint(@JsonProperty(value="layers") List<ShapeLayer> layers) {
        this.layers = layers;
    }

    public List<ShapeLayer> getLayers() {
        return this.layers;
    }
}

