/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.model.search;

import com.socrata.model.search.SearchClauseTypes;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class SearchClause {
    private final SearchClauseTypes clauseType;
    private final String value;

    public SearchClause(SearchClauseTypes clauseType, String value) {
        this.clauseType = clauseType;
        this.value = value;
    }

    public String getQueryParamName() {
        return this.clauseType.queryParam;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        try {
            return this.clauseType.queryParam + "=" + URLEncoder.encode(this.value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ViewTypeSearch
    extends SearchClause {
        public ViewTypeSearch(ViewType viewType) {
            super(SearchClauseTypes.viewType, viewType.value);
        }
    }

    public static enum ViewType {
        view("VIEW"),
        dataset("DATASET");

        public final String value;

        private ViewType(String value) {
            this.value = value;
        }
    }

    public static class MetadataSearch
    extends SearchClause {
        public MetadataSearch(String metadataCategory, String metadataKey, String metadataValue) {
            super(SearchClauseTypes.metadata, metadataCategory + "_" + metadataKey + ":" + metadataValue);
        }
    }

    public static class CategorySearch
    extends SearchClause {
        public CategorySearch(String name) {
            super(SearchClauseTypes.category, name);
        }
    }

    public static class DescriptionSearch
    extends SearchClause {
        public DescriptionSearch(String name) {
            super(SearchClauseTypes.description, name);
        }
    }

    public static class QuerySearch
    extends SearchClause {
        public QuerySearch(String name) {
            super(SearchClauseTypes.query, name);
        }
    }

    public static class TagSearch
    extends SearchClause {
        public TagSearch(String name) {
            super(SearchClauseTypes.tags, name);
        }
    }

    public static class NameSearch
    extends SearchClause {
        public NameSearch(String name) {
            super(SearchClauseTypes.name, name);
        }
    }
}

