/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.model.soql;

import com.google.common.collect.ImmutableList;
import com.socrata.model.soql.Expression;
import com.socrata.model.soql.OrderByClause;
import com.socrata.model.soql.SoqlClauses;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class SoqlQuery {
    public static final SoqlQuery SELECT_ALL = new SoqlQuery(null, null, null, null, null, null, null, null);
    public final ImmutableList<String> selectClause;
    public final Expression whereClause;
    public final ImmutableList<String> groupByClause;
    public final Expression havingClause;
    public final ImmutableList<OrderByClause> orderByClause;
    public final String fullTextSearchClause;
    public final Integer offset;
    public final Integer limit;

    public SoqlQuery(@Nullable List<String> selectClause, @Nullable Expression whereClause, @Nullable List<String> groupByClause, @Nullable Expression havingClause, @Nullable List<OrderByClause> orderByClause, @Nullable String fullTextSearchClause, @Nullable Integer offset, @Nullable Integer limit) {
        this.selectClause = selectClause != null ? ImmutableList.copyOf(selectClause) : null;
        this.groupByClause = groupByClause != null ? ImmutableList.copyOf(groupByClause) : null;
        this.orderByClause = orderByClause != null ? ImmutableList.copyOf(orderByClause) : null;
        this.whereClause = whereClause;
        this.havingClause = havingClause;
        this.fullTextSearchClause = fullTextSearchClause;
        this.offset = offset;
        this.limit = limit;
    }

    public UriBuilder toSodaUri(UriBuilder baseUri) {
        if (this.selectClause != null) {
            String selectString = StringUtils.join(this.selectClause, (String)", ");
            baseUri.queryParam(SoqlClauses.select.urlParam, new Object[]{selectString});
        }
        if (this.whereClause != null) {
            baseUri.queryParam(SoqlClauses.where.urlParam, new Object[]{this.whereClause});
        }
        if (this.groupByClause != null) {
            String groupByString = StringUtils.join(this.groupByClause, (String)", ");
            baseUri.queryParam(SoqlClauses.groupBy.urlParam, new Object[]{groupByString});
        }
        if (this.havingClause != null) {
            baseUri.queryParam(SoqlClauses.having.urlParam, new Object[]{this.havingClause});
        }
        if (this.fullTextSearchClause != null) {
            baseUri.queryParam(SoqlClauses.fullText.urlParam, new Object[]{this.fullTextSearchClause});
        }
        if (this.orderByClause != null) {
            String orderByString = StringUtils.join(this.orderByClause, (String)", ");
            baseUri.queryParam(SoqlClauses.orderBy.urlParam, new Object[]{orderByString});
        }
        if (this.offset != null) {
            baseUri.queryParam(SoqlClauses.offset.urlParam, new Object[]{this.offset});
        }
        if (this.limit != null) {
            baseUri.queryParam(SoqlClauses.limit.urlParam, new Object[]{this.limit});
        }
        return baseUri;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.selectClause != null) {
            builder.append(SoqlClauses.select.soqlKeyword).append(' ').append(StringUtils.join(this.selectClause, (String)",")).append(' ');
        } else {
            builder.append("select * ");
        }
        if (this.whereClause != null) {
            builder.append(SoqlClauses.where.soqlKeyword).append(' ').append(this.whereClause.toString()).append(' ');
        }
        if (this.groupByClause != null) {
            builder.append(SoqlClauses.groupBy.soqlKeyword).append(' ').append(StringUtils.join(this.groupByClause, (String)",")).append(' ');
        }
        if (this.havingClause != null) {
            builder.append(SoqlClauses.having.soqlKeyword).append(' ').append(this.havingClause.toString()).append(' ');
        }
        if (this.fullTextSearchClause != null) {
            builder.append(SoqlClauses.fullText.soqlKeyword).append(' ').append(this.fullTextSearchClause).append(' ');
        }
        if (this.orderByClause != null) {
            builder.append(SoqlClauses.orderBy.soqlKeyword).append(' ').append(StringUtils.join(this.orderByClause, (String)",")).append(' ');
        }
        if (this.offset != null) {
            builder.append(SoqlClauses.offset.soqlKeyword).append(' ').append(this.offset).append(' ');
        }
        if (this.limit != null) {
            builder.append(SoqlClauses.limit.soqlKeyword).append(' ').append(this.limit).append(' ');
        }
        return builder.toString();
    }
}

