/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.utils;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GeneralUtils {
    public static void closeQuietly(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String bestFilePath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ioe) {
            return file.getAbsolutePath();
        }
    }

    public static List<Map<String, Object>> readInCsv(File csvFile) throws IOException {
        FileReader fileReader = new FileReader(csvFile);
        CSVReader reader = new CSVReader((Reader)fileReader);
        ArrayList<Map<String, Object>> retVal = new ArrayList<Map<String, Object>>();
        String[] headers = reader.readNext();
        if (headers != null) {
            String[] currLine;
            while ((currLine = reader.readNext()) != null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (int i = 0; i < headers.length; ++i) {
                    if (!StringUtils.isNotEmpty((CharSequence)currLine[i])) continue;
                    builder.put((Object)headers[i], (Object)currLine[i]);
                }
                retVal.add((Map<String, Object>)builder.build());
            }
        }
        return retVal;
    }
}

