/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.utils.streams;

import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ResizableCircularBuffer {
    final byte[] buffer;
    long currRead = 0L;
    long currWrite = 0L;

    public ResizableCircularBuffer(int buffSize) {
        this.buffer = new byte[buffSize];
    }

    protected ResizableCircularBuffer(byte[] buffer, long currRead, long currWrite) {
        this.buffer = buffer;
        this.currRead = currRead;
        this.currWrite = currWrite;
    }

    public final int getTotalCapacity() {
        return this.buffer.length;
    }

    public final boolean isEmpty() {
        return this.currRead == this.currWrite;
    }

    public final boolean isFull() {
        assert (this.currWrite - this.currRead <= (long)this.getTotalCapacity());
        return this.currWrite - this.currRead == (long)this.getTotalCapacity();
    }

    public final int bytesLeftToWrite() {
        return this.getTotalCapacity() - this.bytesInBuffer();
    }

    public final int bytesInBuffer() {
        assert (this.currWrite - this.currRead <= (long)this.getTotalCapacity());
        return (int)(this.currWrite - this.currRead);
    }

    protected final int byteWritableToEnd() {
        int writeIndex;
        int readIndex = this.toIndex(this.currRead);
        if (readIndex > (writeIndex = this.toIndex(this.currWrite))) {
            return readIndex - writeIndex;
        }
        return this.buffer.length - writeIndex;
    }

    protected final int bytesReadableToEnd() {
        int readIndex = this.toIndex(this.currRead);
        int writeIndex = this.toIndex(this.currWrite);
        if (writeIndex > readIndex) {
            return writeIndex - readIndex;
        }
        return this.buffer.length - readIndex;
    }

    public boolean write(byte b) {
        if (this.isFull()) {
            return false;
        }
        this.buffer[this.toIndex((long)this.currWrite++)] = b;
        return true;
    }

    public int write(byte[] bytes, int off, int len) {
        if (this.isFull()) {
            return 0;
        }
        int bytesWritten = 0;
        int canWriteToEnd = this.byteWritableToEnd();
        bytesWritten = Math.min(canWriteToEnd, len);
        System.arraycopy(bytes, off, this.buffer, this.toIndex(this.currWrite), bytesWritten);
        this.currWrite += (long)bytesWritten;
        if (bytesWritten < len) {
            bytesWritten += this.write(bytes, off + bytesWritten, len - bytesWritten);
        }
        return bytesWritten;
    }

    public byte read() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Reading from an empty Circular Buffer");
        }
        return this.buffer[this.toIndex(this.currRead++)];
    }

    public int read(byte[] b, int off, int len) {
        if (this.isEmpty()) {
            return 0;
        }
        int canReadToEnd = this.bytesReadableToEnd();
        int bytesToRead = Math.min(canReadToEnd, len);
        int readIndex = (int)(this.currRead % (long)this.buffer.length);
        System.arraycopy(this.buffer, readIndex, b, off, bytesToRead);
        this.currRead += (long)bytesToRead;
        if (bytesToRead < len) {
            bytesToRead += this.read(b, off + bytesToRead, len - bytesToRead);
        }
        return bytesToRead;
    }

    public ResizableCircularBuffer resize(int newSize) {
        if (newSize < this.bytesInBuffer()) {
            throw new IllegalArgumentException("Cannot reduce buffer to be smaller than the bytes that are currently in it.");
        }
        ResizableCircularBuffer retVal = new ResizableCircularBuffer(newSize);
        long startingRead = this.currRead;
        int bytesCopied = this.read(retVal.buffer, 0, newSize);
        this.currRead = startingRead;
        assert (bytesCopied == this.bytesInBuffer());
        retVal.currWrite = bytesCopied;
        return retVal;
    }

    public ResizableCircularBuffer copy() {
        byte[] newBuffer = new byte[this.buffer.length];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
        return new ResizableCircularBuffer(newBuffer, this.currRead, this.currWrite);
    }

    private final int toIndex(long totalOps) {
        return (int)(totalOps % (long)this.buffer.length);
    }
}

