/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.utils.streams;

import com.socrata.utils.streams.ResizableCircularBuffer;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SameProcessPipedInputStream
extends InputStream {
    boolean isClosedForWrite = false;
    boolean isClosedForRead = false;
    ResizableCircularBuffer currReadBuffer;

    public SameProcessPipedInputStream(int bufferSize) {
        this.currReadBuffer = new ResizableCircularBuffer(bufferSize);
    }

    @Override
    public int available() throws IOException {
        if (this.isClosedForRead) {
            return 0;
        }
        return this.currReadBuffer.bytesInBuffer();
    }

    @Override
    public int read() throws IOException {
        if (this.isClosedForRead) {
            throw new IOException("The input stream is alread closed.  It cannot be read from");
        }
        if (this.currReadBuffer.isEmpty() && this.isClosedForWrite) {
            return -1;
        }
        return 0xFF & this.currReadBuffer.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isClosedForRead) {
            throw new IOException("The input stream is alread closed.  It cannot be read from");
        }
        if (this.currReadBuffer.isEmpty() && this.isClosedForWrite) {
            return -1;
        }
        return this.currReadBuffer.read(b, off, len);
    }

    public void recieveByte(int b) throws IOException {
        if (this.isClosedForWrite) {
            throw new IOException("Cannot add bytes to this stream, because it is already closed");
        }
        if (this.currReadBuffer.isFull()) {
            int newSize = (int)((double)this.currReadBuffer.getTotalCapacity() * 1.5);
            this.currReadBuffer = this.currReadBuffer.resize(newSize);
        }
        this.currReadBuffer.write((byte)b);
    }

    public void recieveBytes(byte[] b, int off, int len) throws IOException {
        if (this.isClosedForWrite) {
            throw new IOException("Cannot add bytes to this stream, because it is already closed");
        }
        if (this.currReadBuffer.bytesLeftToWrite() < len) {
            int newSize = Math.max((int)((double)this.currReadBuffer.getTotalCapacity() * 1.5), len);
            this.currReadBuffer = this.currReadBuffer.resize(newSize);
        }
        this.currReadBuffer.write(b, off, len);
    }

    public void closeForWrite() {
        this.isClosedForWrite = true;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.isClosedForRead = true;
    }
}

