/*
 * Decompiled with CFR 0.152.
 */
package com.socrata.utils.streams;

import com.socrata.utils.streams.SameProcessPipedInputStream;
import com.socrata.utils.streams.SameProcessPipedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class TransformativeStream
extends InputStream {
    protected SameProcessPipedInputStream pipedInputStream;
    protected OutputStream pipedOutputStream;
    private boolean hasMore = true;

    public TransformativeStream(int bufferSize) {
        this.pipedInputStream = new SameProcessPipedInputStream(bufferSize);
        this.pipedOutputStream = new SameProcessPipedOutputStream(this.pipedInputStream);
    }

    @Override
    public int read() throws IOException {
        while (this.hasMore && this.pipedInputStream.available() == 0) {
            this.hasMore = this.doLoad();
        }
        return this.pipedInputStream.available() > 0 ? this.pipedInputStream.read() : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (this.hasMore && this.pipedInputStream.available() < len) {
            this.hasMore = this.doLoad();
        }
        return this.pipedInputStream.available() > 0 ? this.pipedInputStream.read(b, off, len) : -1;
    }

    @Override
    public int available() throws IOException {
        while (this.hasMore && this.pipedInputStream.available() == 0) {
            this.hasMore = this.loadNext();
        }
        return this.pipedInputStream.available();
    }

    protected boolean doLoad() throws IOException {
        boolean retVal = this.loadNext();
        if (!retVal) {
            this.pipedOutputStream.close();
        }
        return retVal;
    }

    protected abstract boolean loadNext() throws IOException;

    @Override
    public void close() throws IOException {
        super.close();
        this.pipedOutputStream.close();
        this.pipedInputStream.close();
    }
}

