/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.extension.assertj;

import com.soebes.itf.extension.assertj.ArchiveAssert;
import com.soebes.itf.jupiter.maven.MavenProjectResult;
import com.soebes.itf.jupiter.maven.ProjectHelper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarFile;
import org.apache.maven.model.Model;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;

public class MavenProjectResultAssert
extends AbstractAssert<MavenProjectResultAssert, MavenProjectResult> {
    private static final String THE_TARGET_DIRECTORY_DOES_NOT_EXIST = "The target directory of <%s> does not exist.";
    private static final String THE_EAR_FILE_DOES_NOT_EXIST = "The ear file <%s> does not exist or can not be read.";
    private static final String EXPECT_HAVING_A_MODULE = "expected having a module <%s> which does not exist";
    private static final String TARGET = "target";
    private Optional<MavenProjectResultAssert> parent;

    protected MavenProjectResultAssert(MavenProjectResult actual) {
        super((Object)actual, MavenProjectResultAssert.class);
        this.parent = Optional.empty();
    }

    protected MavenProjectResultAssert(MavenProjectResult actual, MavenProjectResultAssert parent) {
        super((Object)actual, MavenProjectResultAssert.class);
        this.parent = Optional.of(parent);
    }

    public static MavenProjectResultAssert assertThat(MavenProjectResult actual) {
        return new MavenProjectResultAssert(actual);
    }

    public MavenProjectResultAssert hasTarget() {
        this.isNotNull();
        File target = new File(((MavenProjectResult)this.actual).getTargetProjectDirectory(), TARGET);
        if (!target.isDirectory() || !target.exists() || target.isHidden()) {
            this.failWithMessage(THE_TARGET_DIRECTORY_DOES_NOT_EXIST, new Object[]{((MavenProjectResult)this.actual).getTargetBaseDirectory().getAbsolutePath()});
        }
        return (MavenProjectResultAssert)this.myself;
    }

    public MavenProjectResultAssert has(String directory) {
        this.isNotNull();
        File target = new File(((MavenProjectResult)this.actual).getTargetProjectDirectory(), directory);
        if (!target.isDirectory() || !target.exists() || target.isHidden()) {
            this.failWithMessage(THE_TARGET_DIRECTORY_DOES_NOT_EXIST, new Object[]{directory, ((MavenProjectResult)this.actual).getTargetBaseDirectory().getAbsolutePath()});
        }
        return (MavenProjectResultAssert)this.myself;
    }

    public AbstractFileAssert<?> withFile(String fileName) {
        this.isNotNull();
        File target = new File(((MavenProjectResult)this.actual).getTargetProjectDirectory(), TARGET);
        if (!target.isDirectory() || !target.exists() || target.isHidden()) {
            this.failWithMessage(THE_TARGET_DIRECTORY_DOES_NOT_EXIST, new Object[]{((MavenProjectResult)this.actual).getTargetBaseDirectory().getAbsolutePath()});
        }
        File fileNameFile = new File(target, fileName);
        return Assertions.assertThat((File)fileNameFile);
    }

    public ArchiveAssert withEarFile() {
        this.isNotNull();
        Model model = ((MavenProjectResult)this.actual).getModel();
        File target = new File(((MavenProjectResult)this.actual).getTargetProjectDirectory(), TARGET);
        String artifact = model.getArtifactId() + "-" + model.getVersion() + ".ear";
        File earFile = new File(target, artifact);
        if (!earFile.isFile() || !earFile.canRead() || earFile.isHidden()) {
            this.failWithMessage(THE_EAR_FILE_DOES_NOT_EXIST, new Object[]{earFile.getAbsolutePath()});
        }
        return new ArchiveAssert(earFile, ((MavenProjectResult)this.actual).getModel(), (MavenProjectResultAssert)this.myself);
    }

    public ArchiveAssert withJarFile() {
        this.isNotNull();
        this.hasTarget();
        Model model = ((MavenProjectResult)this.actual).getModel();
        File target = new File(((MavenProjectResult)this.actual).getTargetProjectDirectory(), TARGET);
        String artifact = model.getArtifactId() + "-" + model.getVersion() + ".jar";
        File jarFile = new File(target, artifact);
        if (!jarFile.isFile() && !jarFile.canRead()) {
            this.failWithMessage(THE_EAR_FILE_DOES_NOT_EXIST, new Object[]{jarFile.getAbsolutePath()});
        }
        return new ArchiveAssert(jarFile, ((MavenProjectResult)this.actual).getModel(), (MavenProjectResultAssert)this.myself);
    }

    public ArchiveAssert withWarFile() {
        this.isNotNull();
        this.hasTarget();
        Model model = ((MavenProjectResult)this.actual).getModel();
        File target = new File(((MavenProjectResult)this.actual).getTargetProjectDirectory(), TARGET);
        String artifact = model.getArtifactId() + "-" + model.getVersion() + ".war";
        File warFile = new File(target, artifact);
        if (!warFile.isFile() && !warFile.canRead()) {
            this.failWithMessage(THE_EAR_FILE_DOES_NOT_EXIST, new Object[]{warFile.getAbsolutePath()});
        }
        return new ArchiveAssert(warFile, ((MavenProjectResult)this.actual).getModel(), (MavenProjectResultAssert)this.myself);
    }

    public ArchiveAssert withRarFile() {
        this.isNotNull();
        this.hasTarget();
        Model model = ((MavenProjectResult)this.actual).getModel();
        File target = new File(((MavenProjectResult)this.actual).getTargetProjectDirectory(), TARGET);
        String artifact = model.getArtifactId() + "-" + model.getVersion() + ".rar";
        File rarFile = new File(target, artifact);
        if (!rarFile.isFile() && !rarFile.canRead()) {
            this.failWithMessage(THE_EAR_FILE_DOES_NOT_EXIST, new Object[]{rarFile.getAbsolutePath()});
        }
        return new ArchiveAssert(rarFile, ((MavenProjectResult)this.actual).getModel(), (MavenProjectResultAssert)this.myself);
    }

    public MavenProjectResultAssert contains(List<String> files) {
        this.isNotNull();
        this.hasTarget();
        Model model = ((MavenProjectResult)this.actual).getModel();
        File target = new File(((MavenProjectResult)this.actual).getTargetProjectDirectory(), TARGET);
        String artifact = model.getArtifactId() + "-" + model.getVersion() + ".ear";
        File earFile = new File(target, artifact);
        try (JarFile jarFile = new JarFile(earFile);){
            if (!files.stream().allMatch(fileEntry -> jarFile.stream().anyMatch(jarEntry -> fileEntry.equals(jarEntry.getName())))) {
                this.failWithMessage(THE_EAR_FILE_DOES_NOT_EXIST, new Object[]{files});
            }
        }
        catch (IOException e) {
            this.failWithMessage("IOException happened. <%s> file:<%s>", new Object[]{e.getMessage(), earFile.getAbsolutePath()});
        }
        return (MavenProjectResultAssert)this.myself;
    }

    public MavenProjectResultAssert hasModule(String moduleName) {
        this.isNotNull();
        File moduleNameFile = new File(((MavenProjectResult)this.actual).getTargetProjectDirectory(), moduleName);
        if (!moduleNameFile.exists() || !moduleNameFile.isHidden() && !moduleNameFile.isDirectory()) {
            this.failWithMessage(EXPECT_HAVING_A_MODULE, new Object[]{moduleName});
        }
        return (MavenProjectResultAssert)this.myself;
    }

    public MavenProjectResultAssert withModule(String moduleName) {
        this.isNotNull();
        File moduleNameFile = new File(((MavenProjectResult)this.actual).getTargetProjectDirectory(), moduleName);
        if (!moduleNameFile.exists() || !moduleNameFile.isHidden() && !moduleNameFile.isDirectory()) {
            this.failWithMessage(EXPECT_HAVING_A_MODULE, new Object[]{moduleName});
        }
        Model model = ProjectHelper.readProject((File)new File(moduleNameFile, "pom.xml"));
        MavenProjectResult mavenProjectResult = new MavenProjectResult(moduleNameFile, moduleNameFile, ((MavenProjectResult)this.actual).getTargetCacheDirectory(), model);
        return new MavenProjectResultAssert(mavenProjectResult);
    }

    public MavenProjectResultAssert isEqualTo(Object expected) {
        this.objects.assertEqual((AssertionInfo)this.info, this.actual, expected);
        return (MavenProjectResultAssert)this.myself;
    }
}

