/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.extension.assertj;

import com.soebes.itf.extension.assertj.MavenProjectResultAssert;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.model.Model;
import org.apiguardian.api.API;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

@API(status=API.Status.EXPERIMENTAL, since="0.8.0")
public class ArchiveAssert
extends AbstractAssert<ArchiveAssert, Path> {
    private static final String CHECKING_EAR_FILE_NAMES = "Checking ear file names.";
    private static final String IOEXCEPTION_HAPPENED = "IOException happened. <%s> file:<%s>";
    private final Model model;
    private final List<String> includes;
    private final MavenProjectResultAssert parent;

    ArchiveAssert(Path earFile, Model model, MavenProjectResultAssert parent) {
        super((Object)earFile, ArchiveAssert.class);
        this.model = model;
        this.includes = new ArrayList<String>();
        this.parent = parent;
        this.ignoreMavenFiles();
        this.ignoreManifest();
    }

    public ArchiveAssert ignoreMavenFiles() {
        this.includes.addAll(Arrays.asList("META-INF/maven/" + this.model.getGroupId() + "/" + this.model.getArtifactId() + "pom.xml", "META-INF/maven/" + this.model.getGroupId() + "/" + this.model.getArtifactId() + "pom.properties"));
        return (ArchiveAssert)this.myself;
    }

    public ArchiveAssert ignoreManifest() {
        this.includes.addAll(Arrays.asList("META-INF/MANIFEST.MF"));
        return (ArchiveAssert)this.myself;
    }

    public ArchiveAssert doesNotContain(String ... files) {
        try (JarFile jarFile = new JarFile(((Path)this.actual).toFile());){
            List<String> localIncludes = Arrays.asList(files);
            ((ListAssert)Assertions.assertThat(jarFile.stream()).describedAs(CHECKING_EAR_FILE_NAMES, new Object[0])).extracting(ZipEntry::getName).doesNotContain((Object[])localIncludes.toArray(new String[0]));
        }
        catch (IOException e) {
            this.failWithMessage(IOEXCEPTION_HAPPENED, new Object[]{e.getMessage()});
        }
        return (ArchiveAssert)this.myself;
    }

    public ArchiveAssert containsOnlyOnce(List<String> files) {
        return this.containsOnlyOnce(files.toArray(new String[0]));
    }

    public ArchiveAssert containsOnlyOnce(String ... files) {
        try (JarFile jarFile = new JarFile(((Path)this.actual).toFile());){
            ((ListAssert)Assertions.assertThat(jarFile.stream()).describedAs(CHECKING_EAR_FILE_NAMES, new Object[0])).extracting(ZipEntry::getName).containsOnlyOnce((Object[])files);
        }
        catch (IOException e) {
            this.failWithMessage(IOEXCEPTION_HAPPENED, new Object[]{e.getMessage()});
        }
        return (ArchiveAssert)this.myself;
    }

    public ArchiveAssert containsOnly(String ... files) {
        try (JarFile jarFile = new JarFile(((Path)this.actual).toFile());){
            ((ListAssert)Assertions.assertThat(jarFile.stream()).describedAs(CHECKING_EAR_FILE_NAMES, new Object[0])).extracting(ZipEntry::getName).containsOnly((Object[])files);
        }
        catch (IOException e) {
            this.failWithMessage(IOEXCEPTION_HAPPENED, new Object[]{e.getMessage()});
        }
        return (ArchiveAssert)this.myself;
    }

    public MavenProjectResultAssert and() {
        return this.parent;
    }

    public ArchiveAssert isEqualTo(Object expected) {
        this.objects.assertEqual((AssertionInfo)this.info, this.actual, expected);
        return (ArchiveAssert)this.myself;
    }

    public int hashCode() {
        return 1;
    }
}

