/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.extension.assertj;

import com.soebes.itf.extension.assertj.ArchiveAssert;
import com.soebes.itf.jupiter.maven.MavenProjectResult;
import com.soebes.itf.jupiter.maven.ProjectHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarFile;
import org.apache.maven.model.Model;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;

public class MavenProjectResultAssert
extends AbstractAssert<MavenProjectResultAssert, MavenProjectResult> {
    private static final String THE_TARGET_DIRECTORY_DOES_NOT_EXIST = "The target directory of <%s> does not exist.";
    private static final String THE_EAR_FILE_DOES_NOT_EXIST = "The ear file <%s> does not exist or can not be read.";
    private static final String EXPECT_HAVING_A_MODULE = "expected having a module <%s> which does not exist";
    private static final String TARGET = "target";
    private Optional<MavenProjectResultAssert> parent = Optional.empty();

    MavenProjectResultAssert(MavenProjectResult actual) {
        super((Object)actual, MavenProjectResultAssert.class);
    }

    public static MavenProjectResultAssert assertThat(MavenProjectResult actual) {
        return new MavenProjectResultAssert(actual);
    }

    public MavenProjectResultAssert hasTarget() {
        this.isNotNull();
        Path target = ((MavenProjectResult)this.actual).getTargetProjectDirectory().resolve(TARGET);
        if (!this.isDirectory(target) || !this.exists(target) || this.isHidden(target)) {
            this.failWithMessage(THE_TARGET_DIRECTORY_DOES_NOT_EXIST, new Object[]{((MavenProjectResult)this.actual).getTargetBaseDirectory().toAbsolutePath()});
        }
        return (MavenProjectResultAssert)this.myself;
    }

    public MavenProjectResultAssert has(String directory) {
        this.isNotNull();
        Path target = ((MavenProjectResult)this.actual).getTargetProjectDirectory().resolve(directory);
        if (!this.isDirectory(target) || !this.exists(target) || this.isHidden(target)) {
            this.failWithMessage(THE_TARGET_DIRECTORY_DOES_NOT_EXIST, new Object[]{directory, ((MavenProjectResult)this.actual).getTargetBaseDirectory().toAbsolutePath()});
        }
        return (MavenProjectResultAssert)this.myself;
    }

    public AbstractPathAssert<?> withFile(String fileName) {
        this.isNotNull();
        Path target = ((MavenProjectResult)this.actual).getTargetProjectDirectory().resolve(TARGET);
        if (!this.isDirectory(target) || !this.exists(target) || this.isHidden(target)) {
            this.failWithMessage(THE_TARGET_DIRECTORY_DOES_NOT_EXIST, new Object[]{((MavenProjectResult)this.actual).getTargetBaseDirectory().toAbsolutePath()});
        }
        Path fileNameFile = target.resolve(fileName);
        return Assertions.assertThat((Path)fileNameFile);
    }

    public ArchiveAssert withEarFile() {
        this.isNotNull();
        Model model = ((MavenProjectResult)this.actual).getModel();
        Path target = ((MavenProjectResult)this.actual).getTargetProjectDirectory().resolve(TARGET);
        String artifact = model.getArtifactId() + "-" + model.getVersion() + ".ear";
        Path earFile = target.resolve(artifact);
        if (!this.isRegularFile(earFile) || !this.isReadable(earFile) || this.isHidden(earFile)) {
            this.failWithMessage(THE_EAR_FILE_DOES_NOT_EXIST, new Object[]{earFile.toAbsolutePath()});
        }
        return new ArchiveAssert(earFile, ((MavenProjectResult)this.actual).getModel(), (MavenProjectResultAssert)this.myself);
    }

    public ArchiveAssert withJarFile() {
        this.isNotNull();
        this.hasTarget();
        Model model = ((MavenProjectResult)this.actual).getModel();
        Path target = ((MavenProjectResult)this.actual).getTargetProjectDirectory().resolve(TARGET);
        String artifact = model.getArtifactId() + "-" + model.getVersion() + ".jar";
        Path jarFile = target.resolve(artifact);
        if (!this.isRegularFile(jarFile) && !this.isReadable(jarFile)) {
            this.failWithMessage(THE_EAR_FILE_DOES_NOT_EXIST, new Object[]{jarFile.toAbsolutePath()});
        }
        return new ArchiveAssert(jarFile, ((MavenProjectResult)this.actual).getModel(), (MavenProjectResultAssert)this.myself);
    }

    public ArchiveAssert withWarFile() {
        this.isNotNull();
        this.hasTarget();
        Model model = ((MavenProjectResult)this.actual).getModel();
        Path target = ((MavenProjectResult)this.actual).getTargetProjectDirectory().resolve(TARGET);
        String artifact = model.getArtifactId() + "-" + model.getVersion() + ".war";
        Path warFile = target.resolve(artifact);
        if (!this.isRegularFile(warFile) && !this.isReadable(warFile)) {
            this.failWithMessage(THE_EAR_FILE_DOES_NOT_EXIST, new Object[]{warFile.toAbsolutePath()});
        }
        return new ArchiveAssert(warFile, ((MavenProjectResult)this.actual).getModel(), (MavenProjectResultAssert)this.myself);
    }

    public ArchiveAssert withRarFile() {
        this.isNotNull();
        this.hasTarget();
        Model model = ((MavenProjectResult)this.actual).getModel();
        Path target = ((MavenProjectResult)this.actual).getTargetProjectDirectory().resolve(TARGET);
        String artifact = model.getArtifactId() + "-" + model.getVersion() + ".rar";
        Path rarFile = target.resolve(artifact);
        if (!this.isRegularFile(rarFile) && !this.isReadable(rarFile)) {
            this.failWithMessage(THE_EAR_FILE_DOES_NOT_EXIST, new Object[]{rarFile.toAbsolutePath()});
        }
        return new ArchiveAssert(rarFile, ((MavenProjectResult)this.actual).getModel(), (MavenProjectResultAssert)this.myself);
    }

    public MavenProjectResultAssert contains(List<String> files) {
        this.isNotNull();
        this.hasTarget();
        Model model = ((MavenProjectResult)this.actual).getModel();
        Path target = ((MavenProjectResult)this.actual).getTargetProjectDirectory().resolve(TARGET);
        String artifact = model.getArtifactId() + "-" + model.getVersion() + ".ear";
        Path earFile = target.resolve(artifact);
        try (JarFile jarFile = new JarFile(earFile.toFile());){
            if (!files.stream().allMatch(fileEntry -> jarFile.stream().anyMatch(jarEntry -> fileEntry.equals(jarEntry.getName())))) {
                this.failWithMessage(THE_EAR_FILE_DOES_NOT_EXIST, new Object[]{files});
            }
        }
        catch (IOException e) {
            this.failWithMessage("IOException happened. <%s> file:<%s>", new Object[]{e.getMessage(), earFile.toAbsolutePath()});
        }
        return (MavenProjectResultAssert)this.myself;
    }

    public MavenProjectResultAssert hasModule(String moduleName) {
        this.isNotNull();
        Path moduleNameFile = ((MavenProjectResult)this.actual).getTargetProjectDirectory().resolve(moduleName);
        if (!this.exists(moduleNameFile) || !this.isHidden(moduleNameFile) && !this.isDirectory(moduleNameFile)) {
            this.failWithMessage(EXPECT_HAVING_A_MODULE, new Object[]{moduleName});
        }
        return (MavenProjectResultAssert)this.myself;
    }

    public MavenProjectResultAssert withModule(String moduleName) {
        this.isNotNull();
        Path moduleNameFile = ((MavenProjectResult)this.actual).getTargetProjectDirectory().resolve(moduleName);
        if (!this.exists(moduleNameFile) || !this.isHidden(moduleNameFile) && !this.isDirectory(moduleNameFile)) {
            this.failWithMessage(EXPECT_HAVING_A_MODULE, new Object[]{moduleName});
        }
        Model model = ProjectHelper.readProject((Path)moduleNameFile.resolve("pom.xml"));
        MavenProjectResult mavenProjectResult = new MavenProjectResult(moduleNameFile, moduleNameFile, ((MavenProjectResult)this.actual).getTargetCacheDirectory(), model);
        return new MavenProjectResultAssert(mavenProjectResult);
    }

    public MavenProjectResultAssert isEqualTo(Object expected) {
        this.objects.assertEqual((AssertionInfo)this.info, this.actual, expected);
        return (MavenProjectResultAssert)this.myself;
    }

    private boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    private boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    private boolean isRegularFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    private boolean isHidden(Path path) {
        try {
            return Files.isHidden(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isReadable(Path path) {
        return Files.isReadable(path);
    }

    public int hashCode() {
        return 1;
    }
}

