/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import com.soebes.itf.jupiter.extension.AnnotationHelper;
import com.soebes.itf.jupiter.extension.DirectoryHelper;
import com.soebes.itf.jupiter.extension.MavenPredefinedRepository;
import com.soebes.itf.jupiter.extension.MavenProject;
import com.soebes.itf.jupiter.extension.MavenRepository;
import com.soebes.itf.jupiter.extension.Storage;
import com.soebes.itf.jupiter.extension.StorageHelper;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;

class DirectoryResolverResult {
    private final Path mavenItTestCaseBaseDirectory;
    private final Path targetMavenItDirectory;
    private final Path targetDirectory;
    private final Path integrationTestCaseDirectory;
    private final Path projectDirectory;
    private final Path targetTestClassesDirectory;
    private final Path sourceMavenProject;
    private final Path cacheDirectory;
    private final Path targetItfRepoDirectory;
    private final Optional<Path> predefinedRepository;

    DirectoryResolverResult(ExtensionContext context) {
        StorageHelper sh = new StorageHelper(context);
        this.mavenItTestCaseBaseDirectory = sh.get(Storage.MAVEN_IT_TESTCASE_BASEDIRECTORY, Path.class);
        this.targetMavenItDirectory = sh.get(Storage.TARGET_MAVEN_IT_DIRECTORY, Path.class);
        this.targetDirectory = sh.get(Storage.TARGET_DIRECTORY, Path.class);
        Method methodName = (Method)context.getTestMethod().orElseThrow(() -> new IllegalStateException("No method given"));
        Optional<Class<?>> mavenProject = AnnotationHelper.findMavenProjectAnnotation(context);
        if (mavenProject.isPresent()) {
            MavenProject mavenProjectAnnotation = mavenProject.get().getAnnotation(MavenProject.class);
            this.integrationTestCaseDirectory = this.getMavenItTestCaseBaseDirectory().resolve(mavenProjectAnnotation.value());
        } else {
            this.integrationTestCaseDirectory = this.getMavenItTestCaseBaseDirectory().resolve(methodName.getName());
        }
        this.projectDirectory = this.integrationTestCaseDirectory.resolve("project");
        this.targetTestClassesDirectory = DirectoryHelper.getTargetDir().resolve("test-classes");
        this.targetItfRepoDirectory = this.getTargetDirectory().resolve("itf-repo");
        Class testClass = (Class)context.getTestClass().orElseThrow(() -> new IllegalStateException("Test class not found."));
        String toFullyQualifiedPath = DirectoryHelper.toFullyQualifiedPath(testClass);
        Path intermediate = this.targetTestClassesDirectory.resolve(toFullyQualifiedPath);
        if (mavenProject.isPresent()) {
            MavenProject mavenProjectAnnotation = mavenProject.get().getAnnotation(MavenProject.class);
            this.sourceMavenProject = intermediate.resolve(mavenProjectAnnotation.value());
        } else {
            this.sourceMavenProject = AnnotationHelper.findMavenProjectSourcesAnnotation(context).map(s -> this.targetTestClassesDirectory.resolve(s.sources())).orElse(intermediate.resolve(methodName.getName()));
        }
        Optional<Class<?>> optionalMavenRepository = AnnotationHelper.findMavenRepositoryAnnotation(context);
        if (optionalMavenRepository.isPresent()) {
            MavenRepository mavenRepository = optionalMavenRepository.get().getAnnotation(MavenRepository.class);
            String repositoryPath = DirectoryHelper.toFullyQualifiedPath(optionalMavenRepository.get());
            Path cacheDirectoryBase = this.targetMavenItDirectory.resolve(repositoryPath);
            this.cacheDirectory = cacheDirectoryBase.resolve(mavenRepository.value());
        } else {
            this.cacheDirectory = this.integrationTestCaseDirectory.resolve(".m2/repository");
        }
        Optional<Class<?>> optionalMavenPredefinedRepository = AnnotationHelper.findMavenPredefinedRepositoryAnnotation(context);
        if (optionalMavenPredefinedRepository.isPresent()) {
            MavenPredefinedRepository mavenRepository = optionalMavenPredefinedRepository.get().getAnnotation(MavenPredefinedRepository.class);
            String repositoryPath = DirectoryHelper.toFullyQualifiedPath(optionalMavenPredefinedRepository.get());
            Path cacheDirectoryBase = this.targetTestClassesDirectory.resolve(repositoryPath);
            this.predefinedRepository = Optional.of(cacheDirectoryBase.resolve(mavenRepository.value()));
        } else {
            this.predefinedRepository = Optional.empty();
        }
    }

    Path getTargetItfRepoDirectory() {
        return this.targetItfRepoDirectory;
    }

    Optional<Path> getPredefinedRepository() {
        return this.predefinedRepository;
    }

    Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    Path getSourceMavenProject() {
        return this.sourceMavenProject;
    }

    Path getProjectDirectory() {
        return this.projectDirectory;
    }

    Path getIntegrationTestCaseDirectory() {
        return this.integrationTestCaseDirectory;
    }

    Path getMavenItTestCaseBaseDirectory() {
        return this.mavenItTestCaseBaseDirectory;
    }

    Path getTargetDirectory() {
        return this.targetDirectory;
    }
}

