/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import com.soebes.itf.jupiter.extension.MavenVersionComparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="0.13.0")
public class MavenVersionParser {
    private static final Pattern QUALIFIER_PATTERN = Pattern.compile("(\\d+)-(\\w+)-(\\d+)");

    private MavenVersionParser() {
    }

    static MavenVersionComparator parseVersion(String version) {
        String[] split = Pattern.compile("\\.").split(version);
        String majorStr = split[0];
        String minorStr = split[1];
        String qualifierStr = split[2];
        Matcher qualifierMatcher = QUALIFIER_PATTERN.matcher(qualifierStr);
        if (qualifierMatcher.matches()) {
            int major = Integer.parseInt(majorStr);
            int minor = Integer.parseInt(minorStr);
            int patch = Integer.parseInt(qualifierMatcher.group(1));
            String qualifier = qualifierMatcher.group(2);
            int qualifierNumber = Integer.parseInt(qualifierMatcher.group(3));
            return MavenVersionComparator.of(major, minor, patch, qualifier, qualifierNumber);
        }
        int major = Integer.parseInt(majorStr);
        int minor = Integer.parseInt(minorStr);
        int patch = Integer.parseInt(qualifierStr);
        return MavenVersionComparator.of(major, minor, patch);
    }
}

