/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.itf.jupiter.extension;

import com.soebes.itf.jupiter.extension.exceptions.PathUtilException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="0.12.0")
public class PathUtils {
    public static Consumer<Path> deletePath = toDelete -> {
        try {
            Files.delete(toDelete);
        }
        catch (IOException e) {
            throw new PathUtilException(e);
        }
    };
    private static final Predicate<Path> FILE = x$0 -> Files.isRegularFile(x$0, new LinkOption[0]);
    private static final Predicate<Path> DIRECTORY = x$0 -> Files.isDirectory(x$0, new LinkOption[0]);
    private static final Predicate<Path> FILE_OR_DIRECTORY = s -> FILE.or(DIRECTORY).test((Path)s);

    private PathUtils() {
    }

    public static Path copy(Path source, Path target) {
        try {
            return Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new PathUtilException(e);
        }
    }

    public static Path createDirectory(Path directoryToCreate) {
        try {
            return Files.createDirectory(directoryToCreate, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new PathUtilException(e);
        }
    }

    public static Stream<Path> list(Path toList) {
        try {
            return Files.list(toList);
        }
        catch (IOException e) {
            throw new PathUtilException(e);
        }
    }

    public static Stream<Path> walk(Path toWalk) {
        try {
            return Files.walk(toWalk, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new PathUtilException(e);
        }
    }

    public static void deleteRecursively(Path target) {
        if (!Files.exists(target, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walk = PathUtils.walk(target);){
            List allElements = walk.filter(FILE_OR_DIRECTORY).collect(Collectors.toList());
            Collections.reverse(allElements);
            allElements.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEachOrdered(deletePath);
        }
    }

    public static void copyDirectoryRecursively(Path source, Path target) {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            PathUtils.copy(source, target);
            return;
        }
        if (Files.notExists(target, new LinkOption[0])) {
            PathUtils.createDirectory(target);
        }
        try (Stream<Path> paths = PathUtils.list(source);){
            paths.forEachOrdered(s -> PathUtils.copyDirectoryRecursively(s, target.resolve(source.relativize((Path)s))));
        }
    }
}

