/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions;

import com.soebes.maven.extensions.GoalKey;
import com.soebes.maven.extensions.ProjectGoal;
import com.soebes.maven.extensions.ProjectKey;
import com.soebes.maven.extensions.SystemTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GoalTimer {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Map<ProjectGoal, SystemTime> timerEvents = new ConcurrentHashMap<ProjectGoal, SystemTime>();

    public boolean hasEvents() {
        return !this.timerEvents.isEmpty();
    }

    private ProjectKey createProjectKey(MavenProject project) {
        return new ProjectKey(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    private GoalKey createGoalKey(MojoExecution mojo) {
        return new GoalKey(mojo.getGroupId(), mojo.getArtifactId(), mojo.getVersion(), mojo.getGoal(), mojo.getExecutionId());
    }

    public void mojoStart(ExecutionEvent event) {
        ProjectGoal pm = new ProjectGoal(this.createProjectKey(event.getProject()), this.createGoalKey(event.getMojoExecution()));
        this.timerEvents.put(pm, new SystemTime().start());
    }

    public void mojoStop(ExecutionEvent event) {
        ProjectGoal pm = new ProjectGoal(this.createProjectKey(event.getProject()), this.createGoalKey(event.getMojoExecution()));
        if (!this.timerEvents.containsKey(pm)) {
            throw new IllegalArgumentException("Unknown mojoId (" + pm + ")");
        }
        this.timerEvents.get(pm).stop();
    }

    public void report() {
        for (Map.Entry<ProjectGoal, SystemTime> item : this.timerEvents.entrySet()) {
            this.LOGGER.info("{} ms : {}", (Object)String.format("%8d", item.getValue().getElapsedTime()), (Object)item.getKey().getId());
        }
    }
}

