/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.plugins.annotations.LifecyclePhase;

class LifeCycleOrdering
extends AbstractEventSpy {
    private final List<String> predefinedPhases = new LinkedList<String>();

    private void initializePredefinedPhases() {
        this.initPredefinedFromTo(LifecyclePhase.PRE_CLEAN, LifecyclePhase.POST_CLEAN);
        this.initPredefinedFromTo(LifecyclePhase.VALIDATE, LifecyclePhase.DEPLOY);
        this.initPredefinedFromTo(LifecyclePhase.PRE_SITE, LifecyclePhase.SITE_DEPLOY);
    }

    private void initPredefinedFromTo(LifecyclePhase from, LifecyclePhase to) {
        LifecyclePhase[] values = LifecyclePhase.values();
        for (int item = from.ordinal(); item <= to.ordinal(); ++item) {
            this.predefinedPhases.add(values[item].id());
        }
    }

    public LifeCycleOrdering() {
        this.initializePredefinedPhases();
    }

    public List<String> getPredefinedPhases() {
        return this.predefinedPhases;
    }

    protected void orderLifeCycleOnPreparedOrder(List<String> lifeCyclePhases) {
        Collections.sort(lifeCyclePhases, new Comparator<String>(){

            @Override
            public int compare(String left, String right) {
                return Integer.compare(LifeCycleOrdering.this.predefinedPhases.indexOf(left), LifeCycleOrdering.this.predefinedPhases.indexOf(right));
            }
        });
    }
}

