/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions;

import com.soebes.maven.extensions.MojoKey;
import com.soebes.maven.extensions.ProjectKey;
import com.soebes.maven.extensions.ProjectMojo;
import com.soebes.maven.extensions.SystemTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MojoTimer {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Map<ProjectMojo, SystemTime> timerEvents = new ConcurrentHashMap<ProjectMojo, SystemTime>();

    private ProjectKey createProjectKey(MavenProject project) {
        return new ProjectKey(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    private MojoKey createMojoKey(MojoExecution mojo) {
        return new MojoKey(mojo.getGroupId(), mojo.getArtifactId(), mojo.getVersion(), mojo.getGoal(), mojo.getExecutionId(), mojo.getLifecyclePhase());
    }

    public boolean hasEvents() {
        return !this.timerEvents.isEmpty();
    }

    public void mojoStart(ExecutionEvent event) {
        ProjectMojo pm = new ProjectMojo(this.createProjectKey(event.getProject()), this.createMojoKey(event.getMojoExecution()));
        this.timerEvents.put(pm, new SystemTime().start());
    }

    public void mojoStop(ExecutionEvent event) {
        ProjectMojo pm = new ProjectMojo(this.createProjectKey(event.getProject()), this.createMojoKey(event.getMojoExecution()));
        if (!this.timerEvents.containsKey(pm)) {
            throw new IllegalArgumentException("Unknown mojoId (" + pm + ")");
        }
        this.timerEvents.get(pm).stop();
    }

    public long getTimeForPhaseInMillis(String phase) {
        long result = 0L;
        for (Map.Entry<ProjectMojo, SystemTime> item : this.timerEvents.entrySet()) {
            if (!phase.equals(item.getKey().getMojo().getPhase())) continue;
            result += item.getValue().getElapsedTime();
        }
        return result;
    }

    public Map<ProjectMojo, SystemTime> getPluginsInPhase(String phase) {
        LinkedHashMap<ProjectMojo, SystemTime> result = new LinkedHashMap<ProjectMojo, SystemTime>();
        for (Map.Entry<ProjectMojo, SystemTime> item : this.timerEvents.entrySet()) {
            if (!phase.equals(item.getKey().getMojo().getPhase())) continue;
            result.put(item.getKey(), item.getValue());
        }
        return result;
    }

    public boolean hasTimeForProjectAndPhase(ProjectKey proKey, String phase) {
        boolean result = false;
        for (Map.Entry<ProjectMojo, SystemTime> item : this.timerEvents.entrySet()) {
            if (!item.getKey().getProject().equals(proKey) || !phase.equals(item.getKey().getMojo().getPhase())) continue;
            result = true;
        }
        return result;
    }

    public long getTimeForProjectAndPhaseInMillis(ProjectKey proKey, String phase) {
        long result = 0L;
        for (Map.Entry<ProjectMojo, SystemTime> item : this.timerEvents.entrySet()) {
            if (!item.getKey().getProject().equals(proKey) || !phase.equals(item.getKey().getMojo().getPhase())) continue;
            result += item.getValue().getElapsedTime();
        }
        return result;
    }

    public void report() {
        for (Map.Entry<ProjectMojo, SystemTime> item : this.timerEvents.entrySet()) {
            this.LOGGER.info("{} : {}", (Object)item.getKey().getId(), (Object)item.getValue().getElapsedTime());
        }
    }
}

