/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions;

import com.soebes.maven.extensions.SystemTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjectTimer {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Map<String, SystemTime> timerEvents = new ConcurrentHashMap<String, SystemTime>();

    private String getProjectId(MavenProject mavenProject) {
        return mavenProject.getId();
    }

    public void projectStart(ExecutionEvent event) {
        String projectId = this.getProjectId(event.getProject());
        this.timerEvents.put(projectId, new SystemTime().start());
    }

    public void projectStop(ExecutionEvent event) {
        String projectId = this.getProjectId(event.getProject());
        if (!this.timerEvents.containsKey(projectId)) {
            throw new IllegalArgumentException("Unknown projectId (" + projectId + ")");
        }
        this.timerEvents.get(projectId).stop();
    }

    public long getTimeForProject(MavenProject project) {
        String projectId = this.getProjectId(project);
        if (!this.timerEvents.containsKey(projectId)) {
            throw new IllegalArgumentException("Unknown projectId (" + projectId + ")");
        }
        return this.timerEvents.get(projectId).getElapsedTime();
    }

    public void report() {
        for (Map.Entry<String, SystemTime> item : this.timerEvents.entrySet()) {
            this.LOGGER.info("ProjectTimer: {} : {}", (Object)item.getKey(), (Object)item.getValue().getElapsedTime());
        }
    }
}

