/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions.artifact;

import com.soebes.maven.extensions.TimePlusSize;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArtifactTimer {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Map<String, TimePlusSize> timerEvents = new ConcurrentHashMap<String, TimePlusSize>();
    private final double MiB = 1048576.0;

    protected String getArtifactId(Artifact artifact) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getVersion());
        if (artifact.getClassifier() != null) {
            sb.append(':').append(artifact.getClassifier());
        }
        sb.append(':').append(artifact.getExtension());
        return sb.toString();
    }

    protected Map<String, TimePlusSize> getTimerEvents() {
        return this.timerEvents;
    }

    public void start(RepositoryEvent event) {
        String artifactId = this.getArtifactId(event.getArtifact());
        TimePlusSize systemTime = new TimePlusSize();
        systemTime.start();
        this.getTimerEvents().put(artifactId, systemTime);
    }

    public void stop(RepositoryEvent event) {
        String artifactId = this.getArtifactId(event.getArtifact());
        if (!this.getTimerEvents().containsKey(artifactId)) {
            throw new IllegalArgumentException("Unknown artifactId (" + artifactId + ")");
        }
        this.getTimerEvents().get(artifactId).stop();
        long size = 0L;
        if (event.getArtifact().getFile() != null) {
            size = event.getArtifact().getFile().length();
        }
        this.getTimerEvents().get(artifactId).setSize(size);
    }

    protected double calculateMegabytesPerSeconds(long timeInMilliseconds, long sizeInBytes) {
        double dividerTime = (double)timeInMilliseconds / 1000.0;
        return (double)sizeInBytes / dividerTime / 1048576.0;
    }
}

