/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions.artifact;

import com.soebes.maven.extensions.TimePlusSize;
import com.soebes.maven.extensions.artifact.AbstractArtifactTimer;
import java.text.NumberFormat;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallTimer
extends AbstractArtifactTimer {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public void report() {
        if (this.getTimerEvents().isEmpty()) {
            return;
        }
        this.LOGGER.info("Installation summary:");
        long totalInstallationTime = 0L;
        long totalInstallationSize = 0L;
        for (Map.Entry<String, TimePlusSize> item : this.getTimerEvents().entrySet()) {
            totalInstallationTime += item.getValue().getElapsedTime();
            totalInstallationSize += item.getValue().getSize();
            this.LOGGER.info("{} ms : {}", (Object)String.format("%8d", item.getValue().getElapsedTime()), (Object)item.getKey());
        }
        double mibPerSeconds = this.calculateMegabytesPerSeconds(totalInstallationTime, totalInstallationSize);
        this.LOGGER.info("{} ms  {} bytes. {} MiB / s", new Object[]{NumberFormat.getIntegerInstance().format(totalInstallationTime), NumberFormat.getIntegerInstance().format(totalInstallationSize), NumberFormat.getNumberInstance().format(mibPerSeconds)});
        this.LOGGER.info("------------------------------------------------------------------------");
    }
}

