/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions.metadata;

import com.soebes.maven.extensions.TimePlusSize;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.metadata.Metadata;

public abstract class AbstractMetadataTimer {
    private Map<String, TimePlusSize> timerEvents = new ConcurrentHashMap<String, TimePlusSize>();

    protected String getArtifactId(Metadata artifact) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getVersion()).append(':').append(artifact.getType()).append(':').append(artifact.getNature());
        return sb.toString();
    }

    protected Map<String, TimePlusSize> getTimerEvents() {
        return this.timerEvents;
    }

    public void start(RepositoryEvent event) {
        String metadataId = this.getArtifactId(event.getMetadata());
        TimePlusSize systemTime = new TimePlusSize();
        systemTime.start();
        this.getTimerEvents().put(metadataId, systemTime);
    }

    public void stop(RepositoryEvent event) {
        String metadataId = this.getArtifactId(event.getMetadata());
        if (!this.getTimerEvents().containsKey(metadataId)) {
            throw new IllegalArgumentException("Unknown metadataId (" + metadataId + ")");
        }
        this.getTimerEvents().get(metadataId).stop();
        long size = 0L;
        if (event.getMetadata().getFile() != null) {
            size = event.getMetadata().getFile().length();
        }
        this.getTimerEvents().get(metadataId).setSize(size);
    }
}

