/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions;

import com.soebes.maven.extensions.BuildTimeProfilerVersion;
import com.soebes.maven.extensions.DiscoveryTimer;
import com.soebes.maven.extensions.ForkTimer;
import com.soebes.maven.extensions.GoalTimer;
import com.soebes.maven.extensions.LifeCycleOrdering;
import com.soebes.maven.extensions.MojoTimer;
import com.soebes.maven.extensions.ProjectKey;
import com.soebes.maven.extensions.ProjectMojo;
import com.soebes.maven.extensions.ProjectTimer;
import com.soebes.maven.extensions.SessionTimer;
import com.soebes.maven.extensions.SystemTime;
import com.soebes.maven.extensions.artifact.DeployTimer;
import com.soebes.maven.extensions.artifact.DownloadTimer;
import com.soebes.maven.extensions.artifact.InstallTimer;
import com.soebes.maven.extensions.metadata.MetadataDeploymentTimer;
import com.soebes.maven.extensions.metadata.MetadataDownloadTimer;
import com.soebes.maven.extensions.metadata.MetadataInstallTimer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositoryEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class BuildTimeProfiler
extends LifeCycleOrdering {
    private static final String SEPARATION_LINE = "------------------------------------------------------------------------";
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildTimeProfiler.class);
    private final List<String> lifeCyclePhases;
    private final DiscoveryTimer discoveryTimer;
    private final GoalTimer goalTimer;
    private final MojoTimer mojoTimer;
    private final ProjectTimer projectTimer;
    private final SessionTimer sessionTimer;
    private final InstallTimer installTimer;
    private final DeployTimer deployTimer;
    private final DownloadTimer downloadTimer;
    private final MetadataDownloadTimer metadataDownloadTimer;
    private final MetadataDeploymentTimer metadataDeploymentTimer;
    private final MetadataInstallTimer metadataInstallTimer;
    private final ForkTimer forkTimer;
    private final ProjectTimer forkProject;
    private boolean activated;

    public BuildTimeProfiler() {
        LOGGER.debug("LifeCycleProfiler ctor called.");
        this.lifeCyclePhases = Collections.synchronizedList(new LinkedList());
        this.discoveryTimer = new DiscoveryTimer();
        this.goalTimer = new GoalTimer();
        this.mojoTimer = new MojoTimer();
        this.projectTimer = new ProjectTimer();
        this.sessionTimer = new SessionTimer();
        this.installTimer = new InstallTimer();
        this.deployTimer = new DeployTimer();
        this.downloadTimer = new DownloadTimer();
        this.metadataDownloadTimer = new MetadataDownloadTimer();
        this.metadataDeploymentTimer = new MetadataDeploymentTimer();
        this.metadataInstallTimer = new MetadataInstallTimer();
        this.forkTimer = new ForkTimer();
        this.forkProject = new ProjectTimer();
        String disabled = System.getProperty("maven-build-time-profiler.disabled", "unknown");
        LOGGER.debug("MBTP: maven-build-time-profiler.disabled {}", (Object)disabled);
        this.activated = !disabled.equals("true");
    }

    public void init(EventSpy.Context context) throws Exception {
        super.init(context);
        LOGGER.info("Maven Build Time Profiler started. (Version {})", (Object)BuildTimeProfilerVersion.getVersion());
        if (!this.activated) {
            LOGGER.info("Maven Build Time Profiler deactivated.");
            return;
        }
        String workingDirectory = (String)context.getData().get("workingDirectory");
        LOGGER.debug("MBTP: workingDirectory: {}", (Object)workingDirectory);
        String multiModuleProjectDirectory = (String)context.getData().get("multiModuleProjectDirectory");
        LOGGER.debug("MBTP: multiModuleProjectDirectory: {}", (Object)multiModuleProjectDirectory);
    }

    public void onEvent(Object event) throws Exception {
        try {
            if (!this.activated) {
                return;
            }
            if (event instanceof ExecutionEvent) {
                this.executionEventHandler((ExecutionEvent)event);
            } else if (event instanceof RepositoryEvent) {
                this.repositoryEventHandler((RepositoryEvent)event);
            } else if (event instanceof MavenExecutionRequest) {
                this.executionRequestEventHandler((MavenExecutionRequest)event);
            } else if (event instanceof MavenExecutionResult) {
                this.executionResultEventHandler((MavenExecutionResult)event);
            } else if (event instanceof DependencyResolutionRequest) {
                this.dependencyResolutionRequest((DependencyResolutionRequest)event);
            } else if (event instanceof DependencyResolutionResult) {
                this.dependencyResolutionResult((DependencyResolutionResult)event);
            } else {
                LOGGER.debug("MBTP: Event {}", (Object)event.getClass().getCanonicalName());
            }
        }
        catch (Exception e) {
            LOGGER.error("MBTP: Exception", (Throwable)e);
        }
    }

    public void close() {
        if (!this.activated) {
            return;
        }
        LOGGER.debug("MBTP: done.");
    }

    private void dependencyResolutionResult(DependencyResolutionResult event) {
        LOGGER.debug("MBTP: dependencyResolutionResult() {}", (Object)event.getResolvedDependencies().size());
    }

    private void dependencyResolutionRequest(DependencyResolutionRequest event) {
        LOGGER.debug("MBTP: dependencyResolutionRequest()");
    }

    private void repositoryEventHandler(RepositoryEvent repositoryEvent) {
        RepositoryEvent.EventType type = repositoryEvent.getType();
        switch (type) {
            case ARTIFACT_DOWNLOADING: {
                LOGGER.debug("MBTP: repositoryEventHandler {}", (Object)type);
                this.downloadTimer.start(repositoryEvent);
                break;
            }
            case ARTIFACT_DOWNLOADED: {
                LOGGER.debug("MBTP: repositoryEventHandler {}", (Object)type);
                this.downloadTimer.stop(repositoryEvent);
                break;
            }
            case ARTIFACT_DEPLOYING: {
                this.deployTimer.start(repositoryEvent);
                break;
            }
            case ARTIFACT_DEPLOYED: {
                this.deployTimer.stop(repositoryEvent);
                break;
            }
            case ARTIFACT_INSTALLING: {
                this.installTimer.start(repositoryEvent);
                break;
            }
            case ARTIFACT_INSTALLED: {
                this.installTimer.stop(repositoryEvent);
                break;
            }
            case METADATA_DEPLOYING: {
                this.metadataDeploymentTimer.start(repositoryEvent);
                break;
            }
            case METADATA_DEPLOYED: {
                this.metadataDeploymentTimer.stop(repositoryEvent);
                break;
            }
            case METADATA_DOWNLOADING: {
                LOGGER.debug("MBTP: repositoryEventHandler {}", (Object)type);
                this.metadataDownloadTimer.start(repositoryEvent);
                break;
            }
            case METADATA_DOWNLOADED: {
                LOGGER.debug("MBTP: repositoryEventHandler {}", (Object)type);
                this.metadataDownloadTimer.stop(repositoryEvent);
                break;
            }
            case METADATA_INSTALLING: {
                LOGGER.debug("MBTP: repositoryEventHandler {}", (Object)type);
                this.metadataInstallTimer.start(repositoryEvent);
                break;
            }
            case METADATA_INSTALLED: {
                LOGGER.debug("MBTP: repositoryEventHandler {}", (Object)type);
                this.metadataInstallTimer.stop(repositoryEvent);
                break;
            }
            case ARTIFACT_RESOLVING: 
            case ARTIFACT_RESOLVED: 
            case ARTIFACT_DESCRIPTOR_INVALID: 
            case ARTIFACT_DESCRIPTOR_MISSING: 
            case METADATA_RESOLVED: 
            case METADATA_RESOLVING: 
            case METADATA_INVALID: {
                break;
            }
            default: {
                LOGGER.error("MBTP: repositoryEventHandler {}", (Object)type);
            }
        }
    }

    private void executionEventHandler(ExecutionEvent executionEvent) {
        if (!this.activated) {
            return;
        }
        LOGGER.debug("executionEventHandler: {}", (Object)executionEvent.getType());
        ExecutionEvent.Type type = executionEvent.getType();
        switch (type) {
            case ProjectDiscoveryStarted: {
                this.discoveryTimer.discoveryStart();
                break;
            }
            case SessionStarted: {
                this.discoveryTimer.discoveryStop();
                this.sessionTimer.sessionStart();
                break;
            }
            case SessionEnded: {
                LOGGER.info("MBTP: Session Ended");
                this.sessionTimer.sessionStop();
                break;
            }
            case ForkStarted: {
                this.forkTimer.start();
                break;
            }
            case ForkFailed: 
            case ForkSucceeded: {
                this.forkTimer.stop();
                break;
            }
            case ForkedProjectStarted: {
                this.forkProject.projectStart(executionEvent);
                break;
            }
            case ForkedProjectFailed: 
            case ForkedProjectSucceeded: {
                this.forkProject.projectStop(executionEvent);
                break;
            }
            case MojoStarted: {
                String phaseStart = executionEvent.getMojoExecution().getLifecyclePhase();
                if (phaseStart == null) {
                    this.goalTimer.mojoStart(executionEvent);
                    break;
                }
                this.collectAllLifeCyclePhases(phaseStart);
                this.mojoTimer.mojoStart(executionEvent);
                break;
            }
            case MojoFailed: 
            case MojoSucceeded: 
            case MojoSkipped: {
                String phaseStop = executionEvent.getMojoExecution().getLifecyclePhase();
                if (phaseStop == null) {
                    this.goalTimer.mojoStop(executionEvent);
                    break;
                }
                this.mojoTimer.mojoStop(executionEvent);
                break;
            }
            case ProjectStarted: {
                this.projectTimer.projectStart(executionEvent);
                break;
            }
            case ProjectFailed: 
            case ProjectSucceeded: 
            case ProjectSkipped: {
                this.projectTimer.projectStop(executionEvent);
                break;
            }
            default: {
                LOGGER.error("MBTP: executionEventHandler: {}", (Object)type);
            }
        }
    }

    private void executionRequestEventHandler(MavenExecutionRequest event) {
        LOGGER.debug("MBTP: executionRequestEventHandler: {}", (Object)event.getExecutionListener());
    }

    private void executionResultEventHandler(MavenExecutionResult event) {
        LOGGER.debug("MBTP: executionResultEventHandler: {}", (Object)event.getProject());
        LOGGER.info("--             Maven Build Time Profiler Summary                      --");
        LOGGER.info(SEPARATION_LINE);
        this.discoveryTimer.report();
        if (this.mojoTimer.hasEvents()) {
            LOGGER.info("Project Build Time (reactor order):");
            LOGGER.info("");
            for (MavenProject mavenProject : event.getTopologicallySortedProjects()) {
                LOGGER.info("{}:", (Object)mavenProject.getName());
                for (String phase : this.lifeCyclePhases) {
                    ProjectKey projectKey = this.mavenProjectToProjectKey(mavenProject);
                    if (!this.mojoTimer.hasTimeForProjectAndPhase(projectKey, phase)) continue;
                    long timeForPhaseAndProjectInMillis = this.mojoTimer.getTimeForProjectAndPhaseInMillis(projectKey, phase);
                    String formattedTime = String.format("%8d", timeForPhaseAndProjectInMillis);
                    LOGGER.info("    {} ms : {}", (Object)formattedTime, (Object)phase);
                }
            }
            LOGGER.info(SEPARATION_LINE);
            LOGGER.info("Lifecycle Phase summary:");
            LOGGER.info("");
            for (String phase : this.lifeCyclePhases) {
                long timeForPhaseInMillis = this.mojoTimer.getTimeForPhaseInMillis(phase);
                LOGGER.info("{} ms : {}", (Object)String.format("%8d", timeForPhaseInMillis), (Object)phase);
            }
            LOGGER.info(SEPARATION_LINE);
            LOGGER.info("Plugins in lifecycle Phases:");
            LOGGER.info("");
            for (String phase : this.lifeCyclePhases) {
                LOGGER.info("{}:", (Object)phase);
                Map<ProjectMojo, SystemTime> plugisInPhase = this.mojoTimer.getPluginsInPhase(phase);
                for (Map.Entry<ProjectMojo, SystemTime> pluginInPhase : plugisInPhase.entrySet()) {
                    LOGGER.info("{} ms: {}", (Object)String.format("%8d", pluginInPhase.getValue().getElapsedTime()), (Object)pluginInPhase.getKey().getMojo().getFullId());
                }
            }
            LOGGER.info("");
            long timeForPlugins = this.mojoTimer.getTimeForPlugins();
            String formattedTime = String.format("%8d", timeForPlugins);
            LOGGER.info("{} ms plugins execution summary.", (Object)formattedTime);
            LOGGER.info(SEPARATION_LINE);
        }
        if (this.goalTimer.hasEvents()) {
            LOGGER.info("Plugins directly called via goals:");
            LOGGER.info("");
            this.goalTimer.report();
            LOGGER.info(SEPARATION_LINE);
        }
        this.installTimer.report();
        this.downloadTimer.report();
        this.deployTimer.report();
        this.metadataInstallTimer.report();
        this.metadataDownloadTimer.report();
        this.metadataDeploymentTimer.report();
        this.forkTimer.report();
        this.forkProject.report();
    }

    private ProjectKey mavenProjectToProjectKey(MavenProject project) {
        return new ProjectKey(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    private void collectAllLifeCyclePhases(String phase) {
        if (phase == null) {
            return;
        }
        LOGGER.debug("collectAllLifeCyclePhases({})", (Object)phase);
        if (!this.lifeCyclePhases.contains(phase)) {
            this.lifeCyclePhases.add(phase);
        }
    }
}

