/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.eventspy.AbstractEventSpy;

class LifeCycleOrdering
extends AbstractEventSpy {
    private final List<String> predefinedPhases = Arrays.stream(Phases.values()).map(Phases::getLifeCyclePhaseName).collect(Collectors.toCollection(LinkedList::new));

    public List<String> getPredefinedPhases() {
        return this.predefinedPhases;
    }

    protected void orderLifeCycleOnPreparedOrder(List<String> lifeCyclePhases) {
        Collections.sort(lifeCyclePhases, (left, right) -> Integer.compare(this.predefinedPhases.indexOf(left), this.predefinedPhases.indexOf(right)));
    }

    private static enum Phases {
        PRE_CLEAN("pre-clean"),
        CLEAN("clean"),
        POST_CLEAN("post-clean"),
        VALIDATE("validate"),
        INITIALIZE("initialize"),
        GENERATE_SOURCES("generate-sources"),
        PROCESS_SOURCES("process-sources"),
        GENERATE_RESOURCES("generate-resources"),
        PROCESS_RESOURCES("process-resources"),
        COMPILE("compile"),
        PROCESS_CLASSES("process-classes"),
        GENERATE_TEST_SOURCES("generate-test-sources"),
        PROCESS_TEST_SOURCES("process-test-sources"),
        GENERATE_TEST_RESOURCES("generate-test-resources"),
        PROCESS_TEST_RESOURCES("process-test-resources"),
        TEST_COMPILE("test-compile"),
        PROCESS_TEST_CLASSES("process-test-classes"),
        TEST("test"),
        PREPARE_PACKAGE("prepare-package"),
        PACKAGE("package"),
        PRE_INTEGRATION_TEST("pre-integration-test"),
        INTEGRATION_TEST("integration-test"),
        POST_INTEGRATION_TEST("post-integration-test"),
        VERIFY("verify"),
        INSTALL("install"),
        DEPLOY("deploy");

        private final String lifeCyclePhaseName;

        private Phases(String lifeCyclePhaseName) {
            this.lifeCyclePhaseName = lifeCyclePhaseName;
        }

        public String getLifeCyclePhaseName() {
            return this.lifeCyclePhaseName;
        }
    }
}

