/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions;

import com.soebes.maven.extensions.MojoKey;
import com.soebes.maven.extensions.ProjectKey;
import com.soebes.maven.extensions.ProjectMojo;
import com.soebes.maven.extensions.SystemTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MojoTimer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MojoTimer.class);
    private final Map<ProjectMojo, SystemTime> timerEvents = new ConcurrentHashMap<ProjectMojo, SystemTime>();

    private ProjectKey createProjectKey(MavenProject project) {
        return new ProjectKey(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    private MojoKey createMojoKey(MojoExecution mojo) {
        return new MojoKey(mojo.getGroupId(), mojo.getArtifactId(), mojo.getVersion(), mojo.getGoal(), mojo.getExecutionId(), mojo.getLifecyclePhase());
    }

    public boolean hasEvents() {
        return !this.timerEvents.isEmpty();
    }

    public void mojoStart(ExecutionEvent event) {
        ProjectMojo pm = new ProjectMojo(this.createProjectKey(event.getProject()), this.createMojoKey(event.getMojoExecution()));
        this.timerEvents.put(pm, new SystemTime().start());
    }

    public void mojoStop(ExecutionEvent event) {
        ProjectMojo pm = new ProjectMojo(this.createProjectKey(event.getProject()), this.createMojoKey(event.getMojoExecution()));
        if (!this.timerEvents.containsKey(pm)) {
            throw new IllegalArgumentException("Unknown mojoId (" + pm + ")");
        }
        this.timerEvents.get(pm).stop();
    }

    public long getTimeForPhaseInMillis(String phase) {
        return this.timerEvents.entrySet().stream().filter(MojoTimer.mojoPhase(phase)).mapToLong(s -> ((SystemTime)s.getValue()).getElapsedTime()).sum();
    }

    public Map<ProjectMojo, SystemTime> getPluginsInPhase(String phase) {
        return this.timerEvents.entrySet().stream().filter(MojoTimer.mojoPhase(phase)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static Predicate<Map.Entry<ProjectMojo, SystemTime>> mojoPhase(String phase) {
        return item -> ((ProjectMojo)item.getKey()).getMojo().getPhase().equals(phase);
    }

    private static Predicate<Map.Entry<ProjectMojo, SystemTime>> projectKey(ProjectKey projectKey) {
        return item -> ((ProjectMojo)item.getKey()).getProject().equals(projectKey);
    }

    public boolean hasTimeForProjectAndPhase(ProjectKey proKey, String phase) {
        return this.timerEvents.entrySet().stream().anyMatch(MojoTimer.mojoPhase(phase).and(MojoTimer.projectKey(proKey)));
    }

    public long getTimeForProjectAndPhaseInMillis(ProjectKey proKey, String phase) {
        return this.timerEvents.entrySet().stream().filter(MojoTimer.mojoPhase(phase)).filter(MojoTimer.projectKey(proKey)).mapToLong(s -> ((SystemTime)s.getValue()).getElapsedTime()).sum();
    }

    public long getTimeForPlugins() {
        return this.timerEvents.values().stream().mapToLong(SystemTime::getElapsedTime).sum();
    }

    public void report() {
        for (Map.Entry<ProjectMojo, SystemTime> item : this.timerEvents.entrySet()) {
            LOGGER.info("{} : {}", (Object)item.getKey().getId(), (Object)item.getValue().getElapsedTime());
        }
    }
}

