/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.extensions.artifact;

import com.soebes.maven.extensions.TimePlusSize;
import com.soebes.maven.extensions.artifact.AbstractArtifactTimer;
import java.text.NumberFormat;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployTimer
extends AbstractArtifactTimer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeployTimer.class);
    private final NumberFormat integerFormat = NumberFormat.getIntegerInstance();
    private final NumberFormat numberFormat = NumberFormat.getNumberInstance();

    public void report() {
        if (this.getTimerEvents().isEmpty()) {
            return;
        }
        LOGGER.info("Deployment summary:");
        long totalInstallationTime = 0L;
        long totalInstallationSize = 0L;
        for (Map.Entry<String, TimePlusSize> item : this.getTimerEvents().entrySet()) {
            totalInstallationTime += item.getValue().getElapsedTime();
            totalInstallationSize += item.getValue().getSize();
            String formattedTime = String.format("%8d", item.getValue().getElapsedTime());
            LOGGER.info("{} ms : {}", (Object)formattedTime, (Object)item.getKey());
        }
        double mibPerSeconds = this.calculateMegabytesPerSeconds(totalInstallationTime, totalInstallationSize);
        String totalInstallationTimeFormatted = String.format("%8d", totalInstallationTime);
        LOGGER.info("");
        LOGGER.info("{} ms  {} bytes. {} MiB / s", new Object[]{totalInstallationTimeFormatted, this.integerFormat.format(totalInstallationSize), this.numberFormat.format(mibPerSeconds)});
        LOGGER.info("------------------------------------------------------------------------");
    }
}

