/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.itexin;

import com.soebes.maven.plugins.itexin.AbstractIteratorMojo;
import com.soebes.maven.plugins.itexin.PluginExecutor;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.exec.MavenPluginManagerHelper;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;

@Mojo(name="executor", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class ExecutorMojo
extends AbstractIteratorMojo {
    @Parameter(required=true)
    private List<PluginExecutor> pluginExecutors;
    @Component
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    protected MavenPluginManagerHelper mavenPluginManagerHelper;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private PluginDescriptor pluginDescriptor;

    private PlexusConfiguration copyConfiguration(PlexusConfiguration src, String iteratorName, String value) {
        XmlPlexusConfiguration dom = new XmlPlexusConfiguration(src.getName());
        if (src.getValue() == null) {
            dom.setValue(src.getValue(null));
        } else if (src.getValue().contains(iteratorName)) {
            dom.setValue(src.getValue().replaceAll(iteratorName, value));
        } else {
            dom.setValue(src.getValue());
        }
        for (String string : src.getAttributeNames()) {
            dom.setAttribute(string, src.getAttribute(string, null));
        }
        for (String string : src.getChildren()) {
            dom.addChild(this.copyConfiguration((PlexusConfiguration)string, iteratorName, value));
        }
        return dom;
    }

    private Plugin getPluginVersionFromPluginManagement(Plugin plugin) {
        if (!this.isPluginManagementDefined()) {
            return plugin;
        }
        if (this.isPluginVersionDefined(plugin)) {
            return plugin;
        }
        Map plugins = this.mavenProject.getPluginManagement().getPluginsAsMap();
        Plugin result = (Plugin)plugins.get(plugin.getKey());
        if (result == null) {
            return plugin;
        }
        return result;
    }

    private boolean isPluginVersionDefined(Plugin plugin) {
        return plugin.getVersion() != null;
    }

    private boolean isPluginManagementDefined() {
        return this.mavenProject.getPluginManagement() != null;
    }

    public void execute() throws MojoExecutionException {
        if (this.isItemsNull() && this.isContentNull()) {
            throw new MojoExecutionException("You have to use at least one. Either items element or content element!");
        }
        if (this.isItemsSet() && this.isContentSet()) {
            throw new MojoExecutionException("You can use only one element. Either items element or content element but not both!");
        }
        for (String item : this.getItems()) {
            for (PluginExecutor pluginExecutor : this.pluginExecutors) {
                Plugin executePlugin = this.getPluginVersionFromPluginManagement(pluginExecutor.getPlugin());
                if (executePlugin.getVersion() == null) {
                    throw new MojoExecutionException("Unknown plugin version. You have to define the version either directly or via pluginManagement.");
                }
                this.getLog().debug((CharSequence)("Configuration(before): " + pluginExecutor.getConfiguration().toString()));
                PlexusConfiguration plexusConfiguration = this.copyConfiguration((PlexusConfiguration)pluginExecutor.getConfiguration(), this.getPlaceHolder(), item);
                this.getLog().debug((CharSequence)("plexusConfiguration(after): " + plexusConfiguration.toString()));
                this.createLogOutput(pluginExecutor, executePlugin);
                this.mavenProject.getProperties().put(this.getIteratorName(), item);
                try {
                    this.executeMojo(executePlugin, pluginExecutor.getGoal(), this.toXpp3Dom(plexusConfiguration));
                }
                catch (PluginResolutionException e) {
                    this.getLog().error((CharSequence)"PluginresourceException:", (Throwable)e);
                }
                catch (PluginDescriptorParsingException e) {
                    this.getLog().error((CharSequence)"PluginDescriptorParsingException:", (Throwable)e);
                }
                catch (InvalidPluginDescriptorException e) {
                    this.getLog().error((CharSequence)"InvalidPluginDescriptorException:", (Throwable)e);
                }
                catch (MojoFailureException e) {
                    this.getLog().error((CharSequence)"MojoFailureException:", (Throwable)e);
                }
                catch (PluginConfigurationException e) {
                    this.getLog().error((CharSequence)"PluginConfigurationException:", (Throwable)e);
                }
                catch (PluginManagerException e) {
                    this.getLog().error((CharSequence)"PluginManagerException:", (Throwable)e);
                }
            }
        }
    }

    private void executeMojo(Plugin plugin, String goal, Xpp3Dom configuration) throws MojoExecutionException, PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException, MojoFailureException, PluginConfigurationException, PluginManagerException {
        if (configuration == null) {
            throw new NullPointerException("configuration may not be null");
        }
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor(plugin);
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
        if (mojoDescriptor == null) {
            throw new MojoExecutionException("Could not find goal '" + goal + "' in plugin " + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion());
        }
        MojoExecution exec = this.mojoExecution(mojoDescriptor, configuration);
        this.pluginManager.executeMojo(this.mavenSession, exec);
    }

    private PluginDescriptor getPluginDescriptor(Plugin plugin) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        return this.mavenPluginManagerHelper.getPluginDescriptor(plugin, this.mavenProject.getRemotePluginRepositories(), this.mavenSession);
    }

    private MojoExecution mojoExecution(MojoDescriptor mojoDescriptor, Xpp3Dom configuration) {
        configuration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)configuration, (Xpp3Dom)this.toXpp3Dom(mojoDescriptor.getMojoConfiguration()));
        return new MojoExecution(mojoDescriptor, configuration);
    }

    public Xpp3Dom toXpp3Dom(PlexusConfiguration config) {
        Xpp3Dom result = new Xpp3Dom(config.getName());
        result.setValue(config.getValue(null));
        for (String string : config.getAttributeNames()) {
            result.setAttribute(string, config.getAttribute(string));
        }
        for (String string : config.getChildren()) {
            result.addChild(this.toXpp3Dom((PlexusConfiguration)string));
        }
        return result;
    }

    private void createLogOutput(PluginExecutor pluginExecutor, Plugin executePlugin) {
        StringBuilder sb = new StringBuilder("------ ");
        sb.append(executePlugin.getKey());
        sb.append(":");
        sb.append(executePlugin.getVersion());
        sb.append(":");
        sb.append(pluginExecutor.getGoal());
        this.getLog().info((CharSequence)sb.toString());
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }
}

