/*
 * Decompiled with CFR 0.152.
 */
package com.soebes.maven.plugins.itexin;

import com.soebes.maven.plugins.itexin.AbstractInvokerMojo;
import com.soebes.maven.plugins.itexin.OutputConsumer;
import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="invoker", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true)
public class InvokerMojo
extends AbstractInvokerMojo {
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(required=true, readonly=true, defaultValue="${session}")
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private PluginDescriptor pluginDescriptor;
    @Parameter
    private File workingDirectory;
    @Component
    private Invoker invoker;

    public void execute() throws MojoExecutionException {
        if (this.isItemsNull() && this.isContentNull()) {
            throw new MojoExecutionException("You have to use at least one. Either items element or content element!");
        }
        if (this.isItemsSet() && this.isContentSet()) {
            throw new MojoExecutionException("You can use only one element. Either items element or content element but not both!");
        }
        File localRepository = new File(this.mavenSession.getSettings().getLocalRepository());
        this.invoker.setLocalRepositoryDirectory(localRepository);
        for (String item : this.getItems()) {
            try {
                this.getLog().info((CharSequence)("mvn " + item));
                this.mavenCall(item);
            }
            catch (MavenInvocationException e) {
                this.getLog().error((CharSequence)"Failure during maven call:", (Throwable)e);
            }
        }
    }

    private File getWorkingDirectoryAfterPlaceHolderIsReplaced(String currentValue) {
        File baseDir = this.getWorkingDirectory();
        if (baseDir != null && baseDir.toString().contains(this.getPlaceHolder())) {
            baseDir = new File(baseDir.toString().replaceAll(this.getPlaceHolder(), currentValue));
        }
        return baseDir;
    }

    private void mavenCall(String item) throws MavenInvocationException {
        InvocationRequest request = this.createAndConfigureAnInvocationRequest(item);
        OutputConsumer output = new OutputConsumer(this.getLog());
        request.setOutputHandler((InvocationOutputHandler)output);
        this.invoker.setWorkingDirectory(this.getWorkingDirectoryAfterPlaceHolderIsReplaced(item));
        InvocationResult result = this.invoker.execute(request);
        if (result.getExitCode() == 0) {
            this.getLog().info((CharSequence)"Maven call Ok.");
        } else {
            this.getLog().error((CharSequence)("Maven call was NOT Ok. (" + result.getExitCode() + ")"));
            if (result.getExecutionException() != null) {
                this.getLog().error((CharSequence)result.getExecutionException().getMessage(), result.getExecutionException().getCause());
            } else {
                this.getLog().error((CharSequence)"No exception");
            }
        }
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public void setThreads(String threads) {
        this.threads = threads;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }
}

